/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.cron.pattern.parser;

import java.util.List;
import org.aoju.bus.core.lang.exception.CrontabException;
import org.aoju.bus.core.toolkit.DateKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.cron.pattern.matcher.AlwaysTrueValueMatcher;
import org.aoju.bus.cron.pattern.matcher.DateTimeMatcher;
import org.aoju.bus.cron.pattern.matcher.MatcherTable;
import org.aoju.bus.cron.pattern.matcher.ValueMatcher;
import org.aoju.bus.cron.pattern.parser.DayOfMonthValueParser;
import org.aoju.bus.cron.pattern.parser.DayOfWeekValueParser;
import org.aoju.bus.cron.pattern.parser.HourValueParser;
import org.aoju.bus.cron.pattern.parser.MinuteValueParser;
import org.aoju.bus.cron.pattern.parser.MonthValueParser;
import org.aoju.bus.cron.pattern.parser.SecondValueParser;
import org.aoju.bus.cron.pattern.parser.ValueParser;
import org.aoju.bus.cron.pattern.parser.YearValueParser;

public class CronPatternParser {
    private static final ValueParser SECOND_VALUE_PARSER = new SecondValueParser();
    private static final ValueParser MINUTE_VALUE_PARSER = new MinuteValueParser();
    private static final ValueParser HOUR_VALUE_PARSER = new HourValueParser();
    private static final ValueParser DAY_OF_MONTH_VALUE_PARSER = new DayOfMonthValueParser();
    private static final ValueParser MONTH_VALUE_PARSER = new MonthValueParser();
    private static final ValueParser DAY_OF_WEEK_VALUE_PARSER = new DayOfWeekValueParser();
    private static final ValueParser YEAR_VALUE_PARSER = new YearValueParser();

    public static MatcherTable parse(String cronPattern) {
        return CronPatternParser.parseGroupPattern(cronPattern);
    }

    private static MatcherTable parseGroupPattern(String groupPattern) {
        List<String> patternList = StringKit.split((CharSequence)groupPattern, '|');
        MatcherTable matcherTable = new MatcherTable(patternList.size());
        for (String pattern : patternList) {
            matcherTable.matchers.add(CronPatternParser.parseSinglePattern(pattern));
        }
        return matcherTable;
    }

    private static DateTimeMatcher parseSinglePattern(String pattern) {
        String[] parts = pattern.split("\\s");
        int offset = 0;
        if (parts.length == 6 || parts.length == 7) {
            offset = 1;
        } else if (parts.length != 5) {
            throw new CrontabException("Pattern [{}] is invalid, it must be 5-7 parts!", pattern);
        }
        String secondPart = 1 == offset ? parts[0] : String.valueOf(DateKit.date().second());
        ValueMatcher yearMatcher = parts.length == 7 ? YEAR_VALUE_PARSER.parseAsValueMatcher(parts[6]) : AlwaysTrueValueMatcher.INSTANCE;
        return new DateTimeMatcher(SECOND_VALUE_PARSER.parseAsValueMatcher(secondPart), MINUTE_VALUE_PARSER.parseAsValueMatcher(parts[offset]), HOUR_VALUE_PARSER.parseAsValueMatcher(parts[1 + offset]), DAY_OF_MONTH_VALUE_PARSER.parseAsValueMatcher(parts[2 + offset]), MONTH_VALUE_PARSER.parseAsValueMatcher(parts[3 + offset]), DAY_OF_WEEK_VALUE_PARSER.parseAsValueMatcher(parts[4 + offset]), yearMatcher);
    }
}

