/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.health.Builder;
import org.aoju.bus.logger.Logger;

@ThreadSafe
public final class Formats {
    public static final String HEX_ERROR = "0x%08X";
    private static final long KIBI = 1024L;
    private static final long MEBI = 0x100000L;
    private static final long GIBI = 0x40000000L;
    private static final long TEBI = 0x10000000000L;
    private static final long PEBI = 0x4000000000000L;
    private static final long EXBI = 0x1000000000000000L;
    private static final long KILO = 1000L;
    private static final long MEGA = 1000000L;
    private static final long GIGA = 1000000000L;
    private static final long TERA = 1000000000000L;
    private static final long PETA = 1000000000000000L;
    private static final long EXA = 1000000000000000000L;
    private static final BigInteger TWOS_COMPLEMENT_REF = BigInteger.ONE.shiftLeft(64);

    public static String formatBytes(long bytes) {
        if (bytes == 1L) {
            return String.format("%d byte", bytes);
        }
        if (bytes < 1024L) {
            return String.format("%d bytes", bytes);
        }
        if (bytes < 0x100000L) {
            return Formats.formatUnits(bytes, 1024L, "KiB");
        }
        if (bytes < 0x40000000L) {
            return Formats.formatUnits(bytes, 0x100000L, "MiB");
        }
        if (bytes < 0x10000000000L) {
            return Formats.formatUnits(bytes, 0x40000000L, "GiB");
        }
        if (bytes < 0x4000000000000L) {
            return Formats.formatUnits(bytes, 0x10000000000L, "TiB");
        }
        if (bytes < 0x1000000000000000L) {
            return Formats.formatUnits(bytes, 0x4000000000000L, "PiB");
        }
        return Formats.formatUnits(bytes, 0x1000000000000000L, "EiB");
    }

    private static String formatUnits(long value, long prefix, String unit) {
        if (value % prefix == 0L) {
            return String.format("%d %s", value / prefix, unit);
        }
        return String.format("%.1f %s", (double)value / (double)prefix, unit);
    }

    public static String formatBytesDecimal(long bytes) {
        if (bytes == 1L) {
            return String.format("%d byte", bytes);
        }
        if (bytes < 1000L) {
            return String.format("%d bytes", bytes);
        }
        return Formats.formatValue(bytes, "B");
    }

    public static String formatHertz(long hertz) {
        return Formats.formatValue(hertz, "Hz");
    }

    public static String formatValue(long value, String unit) {
        if (value < 1000L) {
            return String.format("%d %s", value, unit).trim();
        }
        if (value < 1000000L) {
            return Formats.formatUnits(value, 1000L, "K" + unit);
        }
        if (value < 1000000000L) {
            return Formats.formatUnits(value, 1000000L, "M" + unit);
        }
        if (value < 1000000000000L) {
            return Formats.formatUnits(value, 1000000000L, "G" + unit);
        }
        if (value < 1000000000000000L) {
            return Formats.formatUnits(value, 1000000000000L, "T" + unit);
        }
        if (value < 1000000000000000000L) {
            return Formats.formatUnits(value, 1000000000000000L, "P" + unit);
        }
        return Formats.formatUnits(value, 1000000000000000000L, "E" + unit);
    }

    public static String formatElapsedSecs(long secs) {
        long eTime = secs;
        long days = TimeUnit.SECONDS.toDays(eTime);
        long hr = TimeUnit.SECONDS.toHours(eTime -= TimeUnit.DAYS.toSeconds(days));
        long min = TimeUnit.SECONDS.toMinutes(eTime -= TimeUnit.HOURS.toSeconds(hr));
        long sec = eTime -= TimeUnit.MINUTES.toSeconds(min);
        return String.format("%d days, %02d:%02d:%02d", days, hr, min, sec);
    }

    public static long getUnsignedInt(int x) {
        return (long)x & 0xFFFFFFFFL;
    }

    public static String toUnsignedString(int i) {
        if (i >= 0) {
            return Integer.toString(i);
        }
        return Long.toString(Formats.getUnsignedInt(i));
    }

    public static String toUnsignedString(long l) {
        if (l >= 0L) {
            return Long.toString(l);
        }
        return BigInteger.valueOf(l).add(TWOS_COMPLEMENT_REF).toString();
    }

    public static String formatError(int errorCode) {
        return String.format(HEX_ERROR, errorCode);
    }

    public static int roundToInt(double x) {
        return (int)Math.round(x);
    }

    public static String getManufacturerID(byte[] edid) {
        String temp = String.format("%8s%8s", Integer.toBinaryString(edid[8] & 0xFF), Integer.toBinaryString(edid[9] & 0xFF)).replace(' ', '0');
        Logger.debug("Manufacurer ID: {}", temp);
        return String.format("%s%s%s", Character.valueOf((char)(64 + Integer.parseInt(temp.substring(1, 6), 2))), Character.valueOf((char)(64 + Integer.parseInt(temp.substring(7, 11), 2))), Character.valueOf((char)(64 + Integer.parseInt(temp.substring(12, 16), 2)))).replace("@", "");
    }

    public static String getProductID(byte[] edid) {
        return Integer.toHexString(ByteBuffer.wrap(Arrays.copyOfRange(edid, 10, 12)).order(ByteOrder.LITTLE_ENDIAN).getShort() & 0xFFFF);
    }

    public static String getSerialNo(byte[] edid) {
        if (Logger.get().isDebug()) {
            Logger.debug("Serial number: {}", Arrays.toString(Arrays.copyOfRange(edid, 12, 16)));
        }
        return String.format("%s%s%s%s", Formats.getAlphaNumericOrHex(edid[15]), Formats.getAlphaNumericOrHex(edid[14]), Formats.getAlphaNumericOrHex(edid[13]), Formats.getAlphaNumericOrHex(edid[12]));
    }

    private static String getAlphaNumericOrHex(byte b) {
        return Character.isLetterOrDigit((char)b) ? String.format("%s", Character.valueOf((char)b)) : String.format("%02X", b);
    }

    public static byte getWeek(byte[] edid) {
        return edid[16];
    }

    public static int getYear(byte[] edid) {
        byte temp = edid[17];
        Logger.debug("Year-1990: {}", temp);
        return temp + 1990;
    }

    public static String getVersion(byte[] edid) {
        return edid[18] + "." + edid[19];
    }

    public static boolean isDigital(byte[] edid) {
        return 1 == (edid[20] & 0xFF) >> 7;
    }

    public static int getHcm(byte[] edid) {
        return edid[21];
    }

    public static int getVcm(byte[] edid) {
        return edid[22];
    }

    public static byte[][] getDescriptors(byte[] edid) {
        byte[][] desc = new byte[4][18];
        for (int i = 0; i < desc.length; ++i) {
            System.arraycopy(edid, 54 + 18 * i, desc[i], 0, 18);
        }
        return desc;
    }

    public static int getDescriptorType(byte[] desc) {
        return ByteBuffer.wrap(Arrays.copyOfRange(desc, 0, 4)).getInt();
    }

    public static String getTimingDescriptor(byte[] desc) {
        int clock = ByteBuffer.wrap(Arrays.copyOfRange(desc, 0, 2)).order(ByteOrder.LITTLE_ENDIAN).getShort() / 100;
        int hActive = (desc[2] & 0xFF) + ((desc[4] & 0xF0) << 4);
        int vActive = (desc[5] & 0xFF) + ((desc[7] & 0xF0) << 4);
        return String.format("Clock %dMHz, Active Pixels %dx%d ", clock, hActive, vActive);
    }

    public static String getDescriptorRangeLimits(byte[] desc) {
        return String.format("Field Rate %d-%d Hz vertical, %d-%d Hz horizontal, Max clock: %d MHz", desc[5], desc[6], desc[7], desc[8], desc[9] * 10);
    }

    public static String getDescriptorText(byte[] desc) {
        return new String(Arrays.copyOfRange(desc, 4, 18), StandardCharsets.US_ASCII).trim();
    }

    public static String toString(byte[] edid) {
        byte[][] desc;
        StringBuilder sb = new StringBuilder();
        sb.append("  Manuf. ID=").append(Formats.getManufacturerID(edid));
        sb.append(", Product ID=").append(Formats.getProductID(edid));
        sb.append(", ").append(Formats.isDigital(edid) ? "Digital" : "Analog");
        sb.append(", Serial=").append(Formats.getSerialNo(edid));
        sb.append(", ManufDate=").append(Formats.getWeek(edid) * 12 / 52 + 1).append('/').append(Formats.getYear(edid));
        sb.append(", EDID v").append(Formats.getVersion(edid));
        int hSize = Formats.getHcm(edid);
        int vSize = Formats.getVcm(edid);
        sb.append(String.format("%n  %d x %d cm (%.1f x %.1f in)", hSize, vSize, (double)hSize / 2.54, (double)vSize / 2.54));
        block8: for (byte[] b : desc = Formats.getDescriptors(edid)) {
            switch (Formats.getDescriptorType(b)) {
                case 255: {
                    sb.append("\n  Serial Number: ").append(Formats.getDescriptorText(b));
                    continue block8;
                }
                case 254: {
                    sb.append("\n  Unspecified Text: ").append(Formats.getDescriptorText(b));
                    continue block8;
                }
                case 253: {
                    sb.append("\n  Range Limits: ").append(Formats.getDescriptorRangeLimits(b));
                    continue block8;
                }
                case 252: {
                    sb.append("\n  Monitor Name: ").append(Formats.getDescriptorText(b));
                    continue block8;
                }
                case 251: {
                    sb.append("\n  White Point Data: ").append(Builder.byteArrayToHexString(b));
                    continue block8;
                }
                case 250: {
                    sb.append("\n  Standard Timing ID: ").append(Builder.byteArrayToHexString(b));
                    continue block8;
                }
                default: {
                    if (Formats.getDescriptorType(b) <= 15 && Formats.getDescriptorType(b) >= 0) {
                        sb.append("\n  Manufacturer Data: ").append(Builder.byteArrayToHexString(b));
                        continue block8;
                    }
                    sb.append("\n  Preferred Timing: ").append(Formats.getTimingDescriptor(b));
                }
            }
        }
        return sb.toString();
    }
}

