/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.unix.aix.software;

import com.sun.jna.Native;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.core.lang.RegEx;
import org.aoju.bus.health.Executor;
import org.aoju.bus.health.builtin.software.AbstractNetworkParams;
import org.aoju.bus.health.unix.AixLibc;

@ThreadSafe
final class AixNetworkParams
extends AbstractNetworkParams {
    private static final AixLibc LIBC = AixLibc.INSTANCE;

    AixNetworkParams() {
    }

    private static String getDefaultGateway(String netstat) {
        for (String line : Executor.runNative(netstat)) {
            String[] split = RegEx.SPACES.split(line);
            if (split.length <= 7 || !"default".equals(split[0])) continue;
            return split[1];
        }
        return "unknown";
    }

    @Override
    public String getHostName() {
        byte[] hostnameBuffer = new byte[256];
        if (0 != LIBC.gethostname(hostnameBuffer, hostnameBuffer.length)) {
            return super.getHostName();
        }
        return Native.toString((byte[])hostnameBuffer);
    }

    @Override
    public String getIpv4DefaultGateway() {
        return AixNetworkParams.getDefaultGateway("netstat -rnf inet");
    }

    @Override
    public String getIpv6DefaultGateway() {
        return AixNetworkParams.getDefaultGateway("netstat -rnf inet6");
    }
}

