/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.unix.freebsd.hardware;

import java.util.function.Supplier;
import org.aoju.bus.core.annotation.Immutable;
import org.aoju.bus.core.lang.tuple.Quintet;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Executor;
import org.aoju.bus.health.Memoize;
import org.aoju.bus.health.builtin.hardware.AbstractComputerSystem;
import org.aoju.bus.health.builtin.hardware.Baseboard;
import org.aoju.bus.health.builtin.hardware.Firmware;
import org.aoju.bus.health.unix.UnixBaseboard;
import org.aoju.bus.health.unix.freebsd.BsdSysctlKit;
import org.aoju.bus.health.unix.freebsd.hardware.FreeBsdFirmware;

@Immutable
final class FreeBsdComputerSystem
extends AbstractComputerSystem {
    private final Supplier<Quintet<String, String, String, String, String>> manufModelSerialUuidVers = Memoize.memoize(FreeBsdComputerSystem::readDmiDecode);

    FreeBsdComputerSystem() {
    }

    private static Quintet<String, String, String, String, String> readDmiDecode() {
        String manufacturer = null;
        String model = null;
        String serialNumber = null;
        String uuid = null;
        String version = null;
        String manufacturerMarker = "Manufacturer:";
        String productNameMarker = "Product Name:";
        String serialNumMarker = "Serial Number:";
        String uuidMarker = "UUID:";
        String versionMarker = "Version:";
        for (String checkLine : Executor.runNative("dmidecode -t system")) {
            if (checkLine.contains("Manufacturer:")) {
                manufacturer = checkLine.split("Manufacturer:")[1].trim();
                continue;
            }
            if (checkLine.contains("Product Name:")) {
                model = checkLine.split("Product Name:")[1].trim();
                continue;
            }
            if (checkLine.contains("Serial Number:")) {
                serialNumber = checkLine.split("Serial Number:")[1].trim();
                continue;
            }
            if (checkLine.contains("UUID:")) {
                uuid = checkLine.split("UUID:")[1].trim();
                continue;
            }
            if (!checkLine.contains("Version:")) continue;
            version = checkLine.split("Version:")[1].trim();
        }
        if (StringKit.isBlank(serialNumber)) {
            serialNumber = FreeBsdComputerSystem.querySystemSerialNumber();
        }
        if (StringKit.isBlank(uuid)) {
            uuid = BsdSysctlKit.sysctl("kern.hostuuid", "unknown");
        }
        return new Quintet<String, String, String, String, String>(StringKit.isBlank(manufacturer) ? "unknown" : manufacturer, StringKit.isBlank(model) ? "unknown" : model, StringKit.isBlank(serialNumber) ? "unknown" : serialNumber, StringKit.isBlank(uuid) ? "unknown" : uuid, StringKit.isBlank(version) ? "unknown" : version);
    }

    private static String querySystemSerialNumber() {
        String marker = "system.hardware.serial =";
        for (String checkLine : Executor.runNative("lshal")) {
            if (!checkLine.contains(marker)) continue;
            return Builder.getSingleQuoteStringValue(checkLine);
        }
        return "unknown";
    }

    @Override
    public String getManufacturer() {
        return this.manufModelSerialUuidVers.get().getA();
    }

    @Override
    public String getModel() {
        return this.manufModelSerialUuidVers.get().getB();
    }

    @Override
    public String getSerialNumber() {
        return this.manufModelSerialUuidVers.get().getC();
    }

    @Override
    public String getHardwareUUID() {
        return this.manufModelSerialUuidVers.get().getD();
    }

    @Override
    public Firmware createFirmware() {
        return new FreeBsdFirmware();
    }

    @Override
    public Baseboard createBaseboard() {
        return new UnixBaseboard(this.manufModelSerialUuidVers.get().getA(), this.manufModelSerialUuidVers.get().getB(), this.manufModelSerialUuidVers.get().getC(), this.manufModelSerialUuidVers.get().getE());
    }
}

