/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.windows.drivers.perfmon;

import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.WinReg;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.health.Config;
import org.aoju.bus.logger.Logger;

@ThreadSafe
public final class PerfmonDisabled {
    static final boolean PERF_OS_DISABLED = PerfmonDisabled.isDisabled("bus.os.windows.perfos.disabled", "PerfOS");
    static final boolean PERF_PROC_DISABLED = PerfmonDisabled.isDisabled("bus.os.windows.perfproc.disabled", "PerfProc");
    static final boolean PERF_DISK_DISABLED = PerfmonDisabled.isDisabled("bus.os.windows.perfdisk.disabled", "PerfDisk");

    private PerfmonDisabled() {
        throw new AssertionError();
    }

    private static boolean isDisabled(String config, String service) {
        String perfDisabled = Config.get(config);
        if (StringKit.isBlank(perfDisabled)) {
            String value;
            String key = String.format("SYSTEM\\CurrentControlSet\\Services\\%s\\Performance", service);
            if (Advapi32Util.registryValueExists((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)key, (String)(value = "Disable Performance Counters")) && Advapi32Util.registryGetIntValue((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)key, (String)value) > 0) {
                Logger.warn("{} counters are disabled and won't return data: {}\\\\{}\\\\{} > 0.", service, "HKEY_LOCAL_MACHINE", key, value);
                return true;
            }
            return false;
        }
        return Boolean.parseBoolean(perfDisabled);
    }
}

