/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.windows.hardware;

import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Psapi;
import java.util.Map;
import java.util.function.Supplier;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.core.lang.tuple.Pair;
import org.aoju.bus.core.lang.tuple.Triple;
import org.aoju.bus.health.Memoize;
import org.aoju.bus.health.builtin.hardware.AbstractVirtualMemory;
import org.aoju.bus.health.windows.drivers.perfmon.MemoryInformation;
import org.aoju.bus.health.windows.drivers.perfmon.PagingFile;
import org.aoju.bus.health.windows.hardware.WindowsGlobalMemory;
import org.aoju.bus.logger.Logger;

@ThreadSafe
final class WindowsVirtualMemory
extends AbstractVirtualMemory {
    private final WindowsGlobalMemory global;
    private final Supplier<Long> used = Memoize.memoize(WindowsVirtualMemory::querySwapUsed, Memoize.defaultExpiration());
    private final Supplier<Triple<Long, Long, Long>> totalVmaxVused = Memoize.memoize(WindowsVirtualMemory::querySwapTotalVirtMaxVirtUsed, Memoize.defaultExpiration());
    private final Supplier<Pair<Long, Long>> swapInOut = Memoize.memoize(WindowsVirtualMemory::queryPageSwaps, Memoize.defaultExpiration());

    WindowsVirtualMemory(WindowsGlobalMemory windowsGlobalMemory) {
        this.global = windowsGlobalMemory;
    }

    private static long querySwapUsed() {
        return PagingFile.querySwapUsed().getOrDefault(PagingFile.PagingPercentProperty.PERCENTUSAGE, 0L);
    }

    private static Triple<Long, Long, Long> querySwapTotalVirtMaxVirtUsed() {
        Psapi.PERFORMANCE_INFORMATION perfInfo = new Psapi.PERFORMANCE_INFORMATION();
        if (!Psapi.INSTANCE.GetPerformanceInfo(perfInfo, perfInfo.size())) {
            Logger.error("Failed to get Performance Info. Error code: {}", Kernel32.INSTANCE.GetLastError());
            return Triple.of(0L, 0L, 0L);
        }
        return Triple.of(perfInfo.CommitLimit.longValue() - perfInfo.PhysicalTotal.longValue(), perfInfo.CommitLimit.longValue(), perfInfo.CommitTotal.longValue());
    }

    private static Pair<Long, Long> queryPageSwaps() {
        Map<MemoryInformation.PageSwapProperty, Long> valueMap = MemoryInformation.queryPageSwaps();
        return Pair.of(valueMap.getOrDefault(MemoryInformation.PageSwapProperty.PAGESINPUTPERSEC, 0L), valueMap.getOrDefault(MemoryInformation.PageSwapProperty.PAGESOUTPUTPERSEC, 0L));
    }

    @Override
    public long getSwapUsed() {
        return this.global.getPageSize() * this.used.get();
    }

    @Override
    public long getSwapTotal() {
        return this.global.getPageSize() * this.totalVmaxVused.get().getLeft();
    }

    @Override
    public long getVirtualMax() {
        return this.global.getPageSize() * this.totalVmaxVused.get().getMiddle();
    }

    @Override
    public long getVirtualInUse() {
        return this.global.getPageSize() * this.totalVmaxVused.get().getRight();
    }

    @Override
    public long getSwapPagesIn() {
        return this.swapInOut.get().getLeft();
    }

    @Override
    public long getSwapPagesOut() {
        return this.swapInOut.get().getRight();
    }
}

