/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.http;

import org.aoju.bus.http.Httpd;
import org.aoju.bus.http.NewCall;
import org.aoju.bus.http.magic.GetBuilder;
import org.aoju.bus.http.magic.HttpBuilder;
import org.aoju.bus.http.magic.PostBuilder;
import org.aoju.bus.http.magic.PutBuilder;
import org.aoju.bus.http.secure.SSLSocketFactory;
import org.aoju.bus.http.secure.X509TrustManager;

public class Httpz {
    private static Client client = new Client();

    public static HttpBuilder newBuilder() {
        return new HttpBuilder(client.getHttpd());
    }

    public static HttpBuilder newBuilder(Httpd client) {
        return new HttpBuilder(client);
    }

    public static GetBuilder get() {
        return client.get();
    }

    public static PostBuilder post() {
        return client.post();
    }

    public static PutBuilder put() {
        return client.put();
    }

    public static Client getClient() {
        return client;
    }

    public static void setClient(Client httpClient) {
        client = httpClient;
    }

    public static class Client {
        private Httpd httpd;

        public Client() {
            X509TrustManager trustManager = new X509TrustManager();
            this.httpd = new Httpd().newBuilder().sslSocketFactory(SSLSocketFactory.createTrustAllSSLFactory(trustManager), trustManager).hostnameVerifier((hostname, session) -> true).build();
        }

        public Client(Httpd httpd) {
            this.httpd = httpd;
        }

        public static void cancelAll() {
            Client.cancelAll(client.getHttpd());
        }

        public static void cancelAll(Httpd httpd) {
            if (httpd != null) {
                for (NewCall call : httpd.dispatcher().queuedCalls()) {
                    call.cancel();
                }
                for (NewCall call : httpd.dispatcher().runningCalls()) {
                    call.cancel();
                }
            }
        }

        public static void cancel(Object tag) {
            Client.cancel(client.getHttpd(), tag);
        }

        public static void cancel(Httpd httpd, Object tag) {
            if (httpd != null && tag != null) {
                for (NewCall call : httpd.dispatcher().queuedCalls()) {
                    if (!tag.equals(call.request().tag())) continue;
                    call.cancel();
                }
                for (NewCall call : httpd.dispatcher().runningCalls()) {
                    if (!tag.equals(call.request().tag())) continue;
                    call.cancel();
                }
            }
        }

        public GetBuilder get() {
            return new GetBuilder(this.httpd);
        }

        public PostBuilder post() {
            return new PostBuilder(this.httpd);
        }

        public PutBuilder put() {
            return new PutBuilder(this.httpd);
        }

        public Httpd getHttpd() {
            return this.httpd;
        }

        public void setHttpd(Httpd httpd) {
            this.httpd = httpd;
        }
    }
}

