/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.http.bodys;

import java.io.IOException;
import java.util.concurrent.Executor;
import org.aoju.bus.core.io.Buffer;
import org.aoju.bus.core.io.BufferSink;
import org.aoju.bus.core.io.DelegateSink;
import org.aoju.bus.core.lang.MediaType;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.http.OnBack;
import org.aoju.bus.http.Process;
import org.aoju.bus.http.bodys.RequestBody;

public class ProcessRequestBody
extends RequestBody {
    private RequestBody requestBody;
    private OnBack<Process> onProcess;
    private Executor callbackExecutor;
    private long stepBytes;
    private long step = 0L;
    private Process process;
    private boolean doneCalled = false;
    private BufferSink bufferedSink;

    public ProcessRequestBody(RequestBody requestBody, OnBack<Process> onProcess, Executor callbackExecutor, long contentLength, long stepBytes) {
        this.requestBody = requestBody;
        this.onProcess = onProcess;
        this.callbackExecutor = callbackExecutor;
        this.stepBytes = stepBytes;
        this.process = new Process(contentLength, 0L);
    }

    @Override
    public long contentLength() {
        return this.process.getTotalBytes();
    }

    @Override
    public MediaType contentType() {
        return this.requestBody.contentType();
    }

    @Override
    public void writeTo(BufferSink sink) throws IOException {
        if (null == this.bufferedSink) {
            this.bufferedSink = IoKit.buffer(new DelegateSink(sink){

                @Override
                public void write(Buffer source, long byteCount) throws IOException {
                    super.write(source, byteCount);
                    ProcessRequestBody.this.process.addDoneBytes(byteCount);
                    if (ProcessRequestBody.this.process.notDoneOrReached(ProcessRequestBody.this.step * ProcessRequestBody.this.stepBytes)) {
                        return;
                    }
                    if (ProcessRequestBody.this.process.isDone()) {
                        if (ProcessRequestBody.this.doneCalled) {
                            return;
                        }
                        ProcessRequestBody.this.doneCalled = true;
                    }
                    ++ProcessRequestBody.this.step;
                    ProcessRequestBody.this.callbackExecutor.execute(() -> ProcessRequestBody.this.onProcess.on(ProcessRequestBody.this.process));
                }
            });
        }
        this.requestBody.writeTo(this.bufferedSink);
        this.bufferedSink.flush();
    }
}

