/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.http.metric;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import org.aoju.bus.http.Wapper;
import org.aoju.bus.http.metric.Array;

public interface Convertor {
    public String mediaType();

    public Wapper toMapper(InputStream var1, Charset var2);

    public Array toArray(InputStream var1, Charset var2);

    public byte[] serialize(Object var1, Charset var2);

    public byte[] serialize(Object var1, String var2, Charset var3);

    public <T> T toBean(Class<T> var1, InputStream var2, Charset var3);

    public <T> List<T> toList(Class<T> var1, InputStream var2, Charset var3);

    public static class FormConvertor
    implements Convertor {
        private Convertor convertor;

        public FormConvertor(Convertor convertor) {
            this.convertor = convertor;
        }

        @Override
        public String mediaType() {
            return "application/x-www-form-urlencoded";
        }

        @Override
        public Wapper toMapper(InputStream in, Charset charset) {
            return this.convertor.toMapper(in, charset);
        }

        @Override
        public Array toArray(InputStream in, Charset charset) {
            return this.convertor.toArray(in, charset);
        }

        @Override
        public byte[] serialize(Object object, Charset charset) {
            return this.serialize(object, null, charset);
        }

        @Override
        public byte[] serialize(Object object, String dateFormat, Charset charset) {
            byte[] data = this.convertor.serialize(object, dateFormat, charset);
            Wapper wapper = this.convertor.toMapper(new ByteArrayInputStream(data), charset);
            StringBuilder sb = new StringBuilder();
            for (String key : wapper.keySet()) {
                sb.append(key).append('=').append(wapper.getString(key)).append('&');
            }
            if (sb.length() > 1) {
                sb.deleteCharAt(sb.length() - 1);
            }
            return sb.toString().getBytes(charset);
        }

        @Override
        public <T> T toBean(Class<T> type, InputStream in, Charset charset) {
            return this.convertor.toBean(type, in, charset);
        }

        @Override
        public <T> List<T> toList(Class<T> type, InputStream in, Charset charset) {
            return this.convertor.toList(type, in, charset);
        }
    }
}

