/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.http.metric;

import java.io.EOFException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.aoju.bus.core.io.Buffer;
import org.aoju.bus.core.io.ByteString;
import org.aoju.bus.core.lang.MediaType;
import org.aoju.bus.http.Callback;
import org.aoju.bus.http.DnsX;
import org.aoju.bus.http.Httpd;
import org.aoju.bus.http.NewCall;
import org.aoju.bus.http.Protocol;
import org.aoju.bus.http.Request;
import org.aoju.bus.http.Response;
import org.aoju.bus.http.UnoUrl;
import org.aoju.bus.http.bodys.RequestBody;
import org.aoju.bus.http.bodys.ResponseBody;
import org.aoju.bus.http.cache.CacheControl;
import org.aoju.bus.http.metric.BootstrapDns;
import org.aoju.bus.http.metric.suffix.SuffixDatabase;
import org.aoju.bus.logger.Logger;

public class DnsOverHttps
implements DnsX {
    public static final int TYPE_A = 1;
    public static final int TYPE_AAAA = 28;
    public static final MediaType DNS_MESSAGE = MediaType.valueOf("application/dns-message");
    public static final int MAX_RESPONSE_SIZE = 65536;
    private static final byte SERVFAIL = 2;
    private static final byte NXDOMAIN = 3;
    private final Httpd client;
    private final UnoUrl url;
    private final boolean includeIPv6;
    private final boolean post;
    private final boolean resolvePrivateAddresses;
    private final boolean resolvePublicAddresses;

    DnsOverHttps(Builder builder) {
        if (null == builder.client) {
            throw new NullPointerException("client not set");
        }
        if (null == builder.url) {
            throw new NullPointerException("url not set");
        }
        this.url = builder.url;
        this.includeIPv6 = builder.includeIPv6;
        this.post = builder.post;
        this.resolvePrivateAddresses = builder.resolvePrivateAddresses;
        this.resolvePublicAddresses = builder.resolvePublicAddresses;
        this.client = builder.client.newBuilder().dns(DnsOverHttps.buildBootstrapClient(builder)).build();
    }

    private static DnsX buildBootstrapClient(Builder builder) {
        List<InetAddress> hosts = builder.bootstrapDnsHosts;
        if (null != hosts) {
            return new BootstrapDns(builder.url.host(), hosts);
        }
        return builder.systemDns;
    }

    public static ByteString encodeQuery(String host, int type) {
        String[] labels;
        Buffer buf = new Buffer();
        buf.writeShort(0);
        buf.writeShort(256);
        buf.writeShort(1);
        buf.writeShort(0);
        buf.writeShort(0);
        buf.writeShort(0);
        Buffer nameBuf = new Buffer();
        for (String label : labels = host.split("\\.")) {
            long utf8ByteCount = DnsOverHttps.size(label, 0, label.length());
            if (utf8ByteCount != (long)label.length()) {
                throw new IllegalArgumentException("non-ascii hostname: " + host);
            }
            nameBuf.writeByte((byte)utf8ByteCount);
            nameBuf.writeUtf8(label);
        }
        nameBuf.writeByte(0);
        nameBuf.copyTo(buf, 0L, nameBuf.size());
        buf.writeShort(type);
        buf.writeShort(1);
        return buf.readByteString();
    }

    public static List<InetAddress> decodeAnswers(String hostname, ByteString byteString) throws Exception {
        int i;
        ArrayList<InetAddress> result = new ArrayList<InetAddress>();
        Buffer buf = new Buffer();
        buf.write(byteString);
        buf.readShort();
        int flags = buf.readShort() & 0xFFFF;
        if (flags >> 15 == 0) {
            throw new IllegalArgumentException("not a response");
        }
        byte responseCode = (byte)(flags & 0xF);
        if (responseCode == 3) {
            throw new UnknownHostException(hostname + ": NXDOMAIN");
        }
        if (responseCode == 2) {
            throw new UnknownHostException(hostname + ": SERVFAIL");
        }
        int questionCount = buf.readShort() & 0xFFFF;
        int answerCount = buf.readShort() & 0xFFFF;
        buf.readShort();
        buf.readShort();
        for (i = 0; i < questionCount; ++i) {
            DnsOverHttps.skipName(buf);
            buf.readShort();
            buf.readShort();
        }
        for (i = 0; i < answerCount; ++i) {
            DnsOverHttps.skipName(buf);
            int type = buf.readShort() & 0xFFFF;
            buf.readShort();
            int length = buf.readShort() & 0xFFFF;
            if (type == 1 || type == 28) {
                byte[] bytes = new byte[length];
                buf.read(bytes);
                result.add(InetAddress.getByAddress(bytes));
                continue;
            }
            buf.skip(length);
        }
        return result;
    }

    private static void skipName(Buffer in) throws EOFException {
        byte length = in.readByte();
        if (length < 0) {
            in.skip(1L);
        } else {
            while (length > 0) {
                in.skip(length);
                length = in.readByte();
            }
        }
    }

    public static long size(String string, int beginIndex, int endIndex) {
        if (null == string) {
            throw new IllegalArgumentException("string == null");
        }
        if (beginIndex < 0) {
            throw new IllegalArgumentException("beginIndex < 0: " + beginIndex);
        }
        if (endIndex < beginIndex) {
            throw new IllegalArgumentException("endIndex < beginIndex: " + endIndex + " < " + beginIndex);
        }
        if (endIndex > string.length()) {
            throw new IllegalArgumentException("endIndex > string.length: " + endIndex + " > " + string.length());
        }
        long result = 0L;
        int i = beginIndex;
        while (i < endIndex) {
            char low;
            char c = string.charAt(i);
            if (c < '\u0080') {
                ++result;
                ++i;
                continue;
            }
            if (c < '\u0800') {
                result += 2L;
                ++i;
                continue;
            }
            if (c < '\ud800' || c > '\udfff') {
                result += 3L;
                ++i;
                continue;
            }
            char c2 = low = i + 1 < endIndex ? string.charAt(i + 1) : (char)'\u0000';
            if (c > '\udbff' || low < '\udc00' || low > '\udfff') {
                ++result;
                ++i;
                continue;
            }
            result += 4L;
            i += 2;
        }
        return result;
    }

    static boolean isPrivateHost(String host) {
        return null == SuffixDatabase.get().getEffectiveTldPlusOne(host);
    }

    public UnoUrl url() {
        return this.url;
    }

    public boolean post() {
        return this.post;
    }

    public boolean includeIPv6() {
        return this.includeIPv6;
    }

    public Httpd client() {
        return this.client;
    }

    public boolean resolvePrivateAddresses() {
        return this.resolvePrivateAddresses;
    }

    public boolean resolvePublicAddresses() {
        return this.resolvePublicAddresses;
    }

    @Override
    public List<InetAddress> lookup(String hostname) throws UnknownHostException {
        if (!this.resolvePrivateAddresses || !this.resolvePublicAddresses) {
            boolean privateHost = DnsOverHttps.isPrivateHost(hostname);
            if (privateHost && !this.resolvePrivateAddresses) {
                throw new UnknownHostException("private hosts not resolved");
            }
            if (!privateHost && !this.resolvePublicAddresses) {
                throw new UnknownHostException("public hosts not resolved");
            }
        }
        return this.lookupHttps(hostname);
    }

    private List<InetAddress> lookupHttps(String hostname) throws UnknownHostException {
        ArrayList<NewCall> networkRequests = new ArrayList<NewCall>(2);
        ArrayList<Exception> failures = new ArrayList<Exception>(2);
        ArrayList<InetAddress> results = new ArrayList<InetAddress>(5);
        this.buildRequest(hostname, networkRequests, results, failures, 1);
        if (this.includeIPv6) {
            this.buildRequest(hostname, networkRequests, results, failures, 28);
        }
        this.executeRequests(hostname, networkRequests, results, failures);
        if (!results.isEmpty()) {
            return results;
        }
        return this.throwBestFailure(hostname, failures);
    }

    private void buildRequest(String hostname, List<NewCall> networkRequests, List<InetAddress> results, List<Exception> failures, int type) {
        Request request = this.buildRequest(hostname, type);
        Response response = this.getCacheOnlyResponse(request);
        if (null != response) {
            this.processResponse(response, hostname, results, failures);
        } else {
            networkRequests.add(this.client.newCall(request));
        }
    }

    private void executeRequests(final String hostname, List<NewCall> networkRequests, final List<InetAddress> responses, final List<Exception> failures) {
        final CountDownLatch latch = new CountDownLatch(networkRequests.size());
        for (NewCall call : networkRequests) {
            call.enqueue(new Callback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onFailure(NewCall call, IOException e) {
                    List list = failures;
                    synchronized (list) {
                        failures.add(e);
                    }
                    latch.countDown();
                }

                @Override
                public void onResponse(NewCall call, Response response) {
                    DnsOverHttps.this.processResponse(response, hostname, responses, failures);
                    latch.countDown();
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            failures.add(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processResponse(Response response, String hostname, List<InetAddress> results, List<Exception> failures) {
        try {
            List<InetAddress> addresses = this.readResponse(hostname, response);
            List<InetAddress> list = results;
            synchronized (list) {
                results.addAll(addresses);
            }
        }
        catch (Exception e) {
            List<Exception> list = failures;
            synchronized (list) {
                failures.add(e);
            }
        }
    }

    private List<InetAddress> throwBestFailure(String hostname, List<Exception> failures) throws UnknownHostException {
        if (failures.size() == 0) {
            throw new UnknownHostException(hostname);
        }
        Exception failure = failures.get(0);
        if (failure instanceof UnknownHostException) {
            throw (UnknownHostException)failure;
        }
        UnknownHostException unknownHostException = new UnknownHostException(hostname);
        unknownHostException.initCause(failure);
        for (int i = 1; i < failures.size(); ++i) {
            org.aoju.bus.http.Builder.addSuppressedIfPossible(unknownHostException, failures.get(i));
        }
        throw unknownHostException;
    }

    private Response getCacheOnlyResponse(Request request) {
        if (!this.post && null != this.client.cache()) {
            try {
                Request cacheRequest = request.newBuilder().cacheControl(CacheControl.FORCE_CACHE).build();
                Response cacheResponse = this.client.newCall(cacheRequest).execute();
                if (cacheResponse.code() != 504) {
                    return cacheResponse;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<InetAddress> readResponse(String hostname, Response response) throws Exception {
        if (null == response.cacheResponse() && response.protocol() != Protocol.HTTP_2) {
            Logger.debug("Incorrect protocol: " + response.protocol(), null);
        }
        try {
            if (!response.isSuccessful()) {
                throw new IOException("response: " + response.code() + " " + response.message());
            }
            ResponseBody body = response.body();
            if (body.contentLength() > 65536L) {
                throw new IOException("response size exceeds limit (65536 bytes): " + body.contentLength() + " bytes");
            }
            ByteString responseBytes = body.source().readByteString();
            List<InetAddress> list = DnsOverHttps.decodeAnswers(hostname, responseBytes);
            return list;
        }
        finally {
            response.close();
        }
    }

    private Request buildRequest(String hostname, int type) {
        Request.Builder requestBuilder = new Request.Builder().header("Accept", DNS_MESSAGE.toString());
        ByteString query = DnsOverHttps.encodeQuery(hostname, type);
        if (this.post) {
            requestBuilder = requestBuilder.url(this.url).post(RequestBody.create(DNS_MESSAGE, query));
        } else {
            String encoded = query.base64Url().replace("=", "");
            UnoUrl requestUrl = this.url.newBuilder().addQueryParameter("dns", encoded).build();
            requestBuilder = requestBuilder.url(requestUrl);
        }
        return requestBuilder.build();
    }

    public static final class Builder {
        Httpd client = null;
        UnoUrl url = null;
        boolean includeIPv6 = true;
        boolean post = false;
        DnsX systemDns = DnsX.SYSTEM;
        List<InetAddress> bootstrapDnsHosts = null;
        boolean resolvePrivateAddresses = false;
        boolean resolvePublicAddresses = true;

        public DnsOverHttps build() {
            return new DnsOverHttps(this);
        }

        public Builder client(Httpd client) {
            this.client = client;
            return this;
        }

        public Builder url(UnoUrl url) {
            this.url = url;
            return this;
        }

        public Builder includeIPv6(boolean includeIPv6) {
            this.includeIPv6 = includeIPv6;
            return this;
        }

        public Builder post(boolean post) {
            this.post = post;
            return this;
        }

        public Builder resolvePrivateAddresses(boolean resolvePrivateAddresses) {
            this.resolvePrivateAddresses = resolvePrivateAddresses;
            return this;
        }

        public Builder resolvePublicAddresses(boolean resolvePublicAddresses) {
            this.resolvePublicAddresses = resolvePublicAddresses;
            return this;
        }

        public Builder bootstrapDnsHosts(List<InetAddress> bootstrapDnsHosts) {
            this.bootstrapDnsHosts = bootstrapDnsHosts;
            return this;
        }

        public Builder bootstrapDnsHosts(InetAddress ... bootstrapDnsHosts) {
            return this.bootstrapDnsHosts(Arrays.asList(bootstrapDnsHosts));
        }

        public Builder systemDns(DnsX systemDns) {
            this.systemDns = systemDns;
            return this;
        }
    }
}

