/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.http.metric;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.http.OnBack;
import org.aoju.bus.http.Results;
import org.aoju.bus.http.metric.Convertor;
import org.aoju.bus.http.metric.DownListener;
import org.aoju.bus.http.metric.Download;
import org.aoju.bus.http.metric.TaskListener;
import org.aoju.bus.http.metric.http.CoverHttp;

public final class TaskExecutor {
    private Executor ioExecutor;
    private Executor mainExecutor;
    private DownListener downloadListener;
    private TaskListener<Results> responseListener;
    private TaskListener<IOException> exceptionListener;
    private TaskListener<Results.State> completeListener;
    private Convertor[] convertors;

    public TaskExecutor(Executor ioExecutor, Executor mainExecutor, DownListener downloadListener, TaskListener<Results> responseListener, TaskListener<IOException> exceptionListener, TaskListener<Results.State> completeListener, Convertor[] convertors) {
        this.ioExecutor = ioExecutor;
        this.mainExecutor = mainExecutor;
        this.downloadListener = downloadListener;
        this.responseListener = responseListener;
        this.exceptionListener = exceptionListener;
        this.completeListener = completeListener;
        this.convertors = convertors;
    }

    public Executor getExecutor(boolean onIo) {
        if (onIo || null == this.mainExecutor) {
            return this.ioExecutor;
        }
        return this.mainExecutor;
    }

    public Download download(CoverHttp<?> coverHttp, File file, InputStream input, long skipBytes) {
        Download download = new Download(file, input, this, skipBytes);
        if (null != coverHttp && null != this.downloadListener) {
            this.downloadListener.listen(coverHttp, download);
        }
        return download;
    }

    public void execute(Runnable command, boolean onIo) {
        Executor executor = this.ioExecutor;
        if (null != this.mainExecutor && !onIo) {
            executor = this.mainExecutor;
        }
        executor.execute(command);
    }

    public void executeOnResponse(CoverHttp<?> task, OnBack<Results> onResponse, Results result, boolean onIo) {
        if (null != this.responseListener) {
            if (this.responseListener.listen(task, result) && null != onResponse) {
                this.execute(() -> onResponse.on(result), onIo);
            }
        } else if (null != onResponse) {
            this.execute(() -> onResponse.on(result), onIo);
        }
    }

    public boolean executeOnException(CoverHttp<?> task, OnBack<IOException> onException, IOException error, boolean onIo) {
        if (null != this.exceptionListener) {
            if (this.exceptionListener.listen(task, error) && null != onException) {
                this.execute(() -> onException.on(error), onIo);
            }
        } else if (null != onException) {
            this.execute(() -> onException.on(error), onIo);
        } else {
            return false;
        }
        return true;
    }

    public void executeOnComplete(CoverHttp<?> task, OnBack<Results.State> onComplete, Results.State state, boolean onIo) {
        if (null != this.completeListener) {
            if (this.completeListener.listen(task, state) && null != onComplete) {
                this.execute(() -> onComplete.on(state), onIo);
            }
        } else if (null != onComplete) {
            this.execute(() -> onComplete.on(state), onIo);
        }
    }

    public <V> V doMsgConvert(ConvertFunc<V> callable) {
        return (V)this.doMsgConvert(null, callable).data;
    }

    public <V> Data<V> doMsgConvert(String type, ConvertFunc<V> callable) {
        Exception cause = null;
        for (int i = this.convertors.length - 1; i >= 0; --i) {
            Convertor convertor = this.convertors[i];
            String mediaType = convertor.mediaType();
            if (null != type && (null == mediaType || !mediaType.contains(type))) continue;
            if (null == callable && null != mediaType) {
                return new Data<Object>(null, mediaType);
            }
            try {
                assert (null != callable);
                return new Data<V>(callable.apply(convertor), mediaType);
            }
            catch (Exception e) {
                if (null != cause) {
                    this.initRootCause(e, cause);
                }
                cause = e;
            }
        }
        if (null == callable) {
            return new Data<Object>(null, this.toMediaType(type));
        }
        if (null != cause) {
            throw new InstrumentException("Conversion failed", cause);
        }
        throw new InstrumentException("No match[" + type + "]Type converter\uff01");
    }

    private String toMediaType(String type) {
        if (type != null) {
            String lower = type.toLowerCase();
            if (lower.contains("json")) {
                return "application/json";
            }
            if (lower.contains("xml")) {
                return "application/xml";
            }
            if (lower.contains("protobuf")) {
                return "application/x-protobuf";
            }
        }
        return "application/x-www-form-urlencoded";
    }

    private void initRootCause(Throwable throwable, Throwable cause) {
        Throwable lastCause = throwable.getCause();
        if (null != lastCause) {
            this.initRootCause(lastCause, cause);
        } else {
            throwable.initCause(cause);
        }
    }

    public void shutdown() {
        if (null != this.ioExecutor && this.ioExecutor instanceof ExecutorService) {
            ((ExecutorService)this.ioExecutor).shutdown();
        }
        if (null != this.mainExecutor && this.mainExecutor instanceof ExecutorService) {
            ((ExecutorService)this.mainExecutor).shutdown();
        }
    }

    public Executor getIoExecutor() {
        return this.ioExecutor;
    }

    public Executor getMainExecutor() {
        return this.mainExecutor;
    }

    public DownListener getDownloadListener() {
        return this.downloadListener;
    }

    public TaskListener<Results> getResponseListener() {
        return this.responseListener;
    }

    public TaskListener<IOException> getExceptionListener() {
        return this.exceptionListener;
    }

    public TaskListener<Results.State> getCompleteListener() {
        return this.completeListener;
    }

    public Convertor[] getConvertors() {
        return this.convertors;
    }

    public static interface ConvertFunc<T> {
        public T apply(Convertor var1);
    }

    public static class Data<T> {
        public T data;
        public String mediaType;

        public Data(T data, String mediaType) {
            this.data = data;
            this.mediaType = mediaType;
        }
    }
}

