/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.metric;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.image.Device;
import org.aoju.bus.image.Dimse;
import org.aoju.bus.image.Option;
import org.aoju.bus.image.Status;
import org.aoju.bus.image.galaxy.Capacity;
import org.aoju.bus.image.galaxy.data.Attributes;
import org.aoju.bus.image.galaxy.data.VR;
import org.aoju.bus.image.metric.ApplicationEntity;
import org.aoju.bus.image.metric.AssociationListener;
import org.aoju.bus.image.metric.AssociationMonitor;
import org.aoju.bus.image.metric.CancelRQHandler;
import org.aoju.bus.image.metric.Commands;
import org.aoju.bus.image.metric.Connection;
import org.aoju.bus.image.metric.DataWriter;
import org.aoju.bus.image.metric.DataWriterAdapter;
import org.aoju.bus.image.metric.DimseRSP;
import org.aoju.bus.image.metric.DimseRSPHandler;
import org.aoju.bus.image.metric.FutureDimseRSP;
import org.aoju.bus.image.metric.PDVInputStream;
import org.aoju.bus.image.metric.Timeout;
import org.aoju.bus.image.metric.TransferCapability;
import org.aoju.bus.image.metric.internal.pdu.AAbort;
import org.aoju.bus.image.metric.internal.pdu.AAssociateAC;
import org.aoju.bus.image.metric.internal.pdu.AAssociateRJ;
import org.aoju.bus.image.metric.internal.pdu.AAssociateRQ;
import org.aoju.bus.image.metric.internal.pdu.CommonExtended;
import org.aoju.bus.image.metric.internal.pdu.PDUDecoder;
import org.aoju.bus.image.metric.internal.pdu.PDUEncoder;
import org.aoju.bus.image.metric.internal.pdu.Presentation;
import org.aoju.bus.image.metric.internal.pdu.RoleSelection;
import org.aoju.bus.logger.Logger;

public class Association {
    private static final AtomicInteger prevSerialNo = new AtomicInteger();
    private final AtomicInteger messageID = new AtomicInteger();
    private final AtomicIntegerArray dimseCounters = new AtomicIntegerArray(46);
    private final long connectTime;
    private final int serialNo;
    private final boolean requestor;
    private final Device device;
    private final AssociationMonitor monitor;
    private final Connection conn;
    private final Socket sock;
    private final InputStream in;
    private final OutputStream out;
    private final PDUEncoder encoder;
    private final Capacity<DimseRSPHandler> rspHandlerForMsgId = new Capacity();
    private final Capacity<CancelRQHandler> cancelHandlerForMsgId = new Capacity();
    private final Map<String, Map<String, Presentation>> pcMap = new HashMap<String, Map<String, Presentation>>();
    private final LinkedList<AssociationListener> listeners = new LinkedList();
    private String name;
    private ApplicationEntity ae;
    private PDUDecoder decoder;
    private State state;
    private AAssociateRQ rq;
    private AAssociateAC ac;
    private IOException ex;
    private Map<String, Object> properties;
    private int maxOpsInvoked;
    private int maxPDULength;
    private int performing;
    private Timeout timeout;

    Association(ApplicationEntity ae, Connection local, Socket sock) throws IOException {
        this.connectTime = System.currentTimeMillis();
        this.serialNo = prevSerialNo.incrementAndGet();
        this.ae = ae;
        this.requestor = null != ae;
        this.name = sock.getLocalSocketAddress() + this.delim() + sock.getRemoteSocketAddress() + "(" + this.serialNo + ")";
        this.conn = local;
        this.device = local.getDevice();
        this.monitor = this.device.getAssociationMonitor();
        this.sock = sock;
        this.in = sock.getInputStream();
        this.out = sock.getOutputStream();
        this.encoder = new PDUEncoder(this, this.out);
        if (this.requestor) {
            this.enterState(State.Sta4);
        } else {
            this.enterState(State.Sta2);
            this.startRequestTimeout();
        }
        this.activate();
    }

    static int minZeroAsMax(int i1, int i2) {
        return i1 == 0 ? i2 : (i2 == 0 ? i1 : Math.min(i1, i2));
    }

    public long getConnectTimeInMillis() {
        return this.connectTime;
    }

    public int getSerialNo() {
        return this.serialNo;
    }

    public Device getDevice() {
        return this.device;
    }

    public int nextMessageID() {
        return this.messageID.incrementAndGet() & 0xFFFF;
    }

    private String delim() {
        return this.requestor ? "->" : "<-";
    }

    public int getNumberOfSent(Dimse dimse) {
        return this.dimseCounters.get(dimse.ordinal());
    }

    public int getNumberOfReceived(Dimse dimse) {
        return this.dimseCounters.get(23 + dimse.ordinal());
    }

    public void incSentCount(Dimse dimse) {
        this.dimseCounters.getAndIncrement(dimse.ordinal());
    }

    void incReceivedCount(Dimse dimse) {
        this.dimseCounters.getAndIncrement(23 + dimse.ordinal());
    }

    public String toString() {
        return this.name;
    }

    public final Socket getSocket() {
        return this.sock;
    }

    public final Connection getConnection() {
        return this.conn;
    }

    public final AAssociateRQ getAAssociateRQ() {
        return this.rq;
    }

    public final AAssociateAC getAAssociateAC() {
        return this.ac;
    }

    public final IOException getException() {
        return this.ex;
    }

    public final ApplicationEntity getApplicationEntity() {
        return this.ae;
    }

    public Set<String> getPropertyNames() {
        return null != this.properties ? this.properties.keySet() : Collections.emptySet();
    }

    public Object getProperty(String key) {
        return null != this.properties ? this.properties.get(key) : null;
    }

    public <T> T getProperty(Class<T> clazz) {
        return (T)this.getProperty(clazz.getName());
    }

    public <T> void setProperty(Class<T> clazz, Object value) {
        this.setProperty(clazz.getName(), value);
    }

    public boolean containsProperty(String key) {
        return null != this.properties && this.properties.containsKey(key);
    }

    public Object setProperty(String key, Object value) {
        if (null == this.properties) {
            this.properties = new HashMap<String, Object>();
        }
        return this.properties.put(key, value);
    }

    public Object clearProperty(String key) {
        return null != this.properties ? this.properties.remove(key) : null;
    }

    public void addAssociationListener(AssociationListener listener) {
        this.listeners.add(listener);
    }

    public void removeAssociationListener(AssociationListener listener) {
        this.listeners.remove(listener);
    }

    public final boolean isRequestor() {
        return this.requestor;
    }

    public boolean isReadyForDataTransfer() {
        return this.state == State.Sta6;
    }

    private void checkIsSCP(String cuid) throws InstrumentException {
        if (!this.isSCPFor(cuid)) {
            InstrumentException ex = new InstrumentException(cuid, new Object[]{TransferCapability.Role.SCP});
            if (this.ae.isRoleSelectionNegotiationLenient() && null == this.ac.getRoleSelectionFor(cuid)) {
                Logger.info("{}: {}", this, ex.getMessage());
            } else {
                throw ex;
            }
        }
    }

    public boolean isSCPFor(String cuid) {
        RoleSelection rolsel = this.ac.getRoleSelectionFor(cuid);
        if (null == rolsel) {
            return !this.requestor;
        }
        return this.requestor ? rolsel.isSCP() : rolsel.isSCU();
    }

    private void checkIsSCU(String cuid) throws InstrumentException {
        if (!this.isSCUFor(cuid)) {
            InstrumentException ex = new InstrumentException(cuid, new Object[]{TransferCapability.Role.SCU});
            if (this.ae.isRoleSelectionNegotiationLenient() && null == this.ac.getRoleSelectionFor(cuid)) {
                Logger.info("{}: {}", this, ex.getMessage());
            } else {
                throw ex;
            }
        }
    }

    public boolean isSCUFor(String cuid) {
        RoleSelection rolsel = this.ac.getRoleSelectionFor(cuid);
        if (null == rolsel) {
            return this.requestor;
        }
        return this.requestor ? rolsel.isSCU() : rolsel.isSCP();
    }

    public String getCallingAET() {
        return null != this.rq ? this.rq.getCallingAET() : null;
    }

    public String getCalledAET() {
        return null != this.rq ? this.rq.getCalledAET() : null;
    }

    public String getRemoteAET() {
        return this.requestor ? this.getCalledAET() : this.getCallingAET();
    }

    public String getLocalAET() {
        return this.requestor ? this.getCallingAET() : this.getCalledAET();
    }

    public String getRemoteImplVersionName() {
        return (this.requestor ? this.ac : this.rq).getImplVersionName();
    }

    public String getRemoteImplClassUID() {
        return (this.requestor ? this.ac : this.rq).getImplClassUID();
    }

    public String getLocalImplVersionName() {
        return (this.requestor ? this.rq : this.ac).getImplVersionName();
    }

    public String getLocalImplClassUID() {
        return (this.requestor ? this.rq : this.ac).getImplClassUID();
    }

    public final int getMaxPDULengthSend() {
        return this.maxPDULength;
    }

    public boolean isPackPDV() {
        return this.conn.isPackPDV();
    }

    public void release() throws IOException {
        this.state.writeAReleaseRQ(this);
    }

    public void abort() {
        this.abort(new AAbort());
    }

    void abort(AAbort aa) {
        try {
            this.state.write(this, aa);
        }
        catch (IOException e) {
            Logger.error(e.getMessage(), new Object[0]);
        }
    }

    private synchronized void closeSocket() {
        this.state.closeSocket(this);
    }

    void doCloseSocket() {
        Logger.info("{}: close {}", this.name, this.sock);
        IoKit.close(this.sock);
        this.enterState(State.Sta1);
    }

    private synchronized void closeSocketDelayed() {
        this.state.closeSocketDelayed(this);
    }

    void doCloseSocketDelayed() {
        this.enterState(State.Sta13);
        int delay = this.conn.getSocketCloseDelay();
        if (delay > 0) {
            this.device.schedule(() -> this.closeSocket(), delay, TimeUnit.MILLISECONDS);
            Logger.debug("{}: closing {} in {} ms", this.name, this.sock, delay);
        } else {
            this.closeSocket();
        }
    }

    public synchronized void onIOException(IOException e) {
        if (null != this.ex) {
            return;
        }
        this.ex = e;
        Logger.info("{}: i/o exception: {} in State: {}", new Object[]{this.name, e, this.state});
        this.closeSocket();
    }

    void write(AAbort aa) throws IOException {
        Logger.info("{} << {}", this.name, aa.toString());
        this.encoder.write(aa);
        this.ex = aa;
        this.closeSocketDelayed();
    }

    void writeAReleaseRQ() throws IOException {
        Logger.info("{} << A-RELEASE-RQ", this.name);
        this.enterState(State.Sta7);
        this.stopTimeout();
        this.encoder.writeAReleaseRQ();
        this.startReleaseTimeout();
    }

    private void startRequestTimeout() {
        this.startTimeout("{}: start A-ASSOCIATE-RQ timeout of {}ms", "{}: A-ASSOCIATE-RQ timeout expired", "{}: stop A-ASSOCIATE-RQ timeout", this.conn.getRequestTimeout(), State.Sta2);
    }

    private void startAcceptTimeout() {
        this.startTimeout("{}: start A-ASSOCIATE-AC timeout of {}ms", "{}: A-ASSOCIATE-AC timeout expired", "{}: stop A-ASSOCIATE-AC timeout", this.conn.getAcceptTimeout(), State.Sta5);
    }

    private void startReleaseTimeout() {
        this.startTimeout("{}: start A-RELEASE-RP timeout of {}ms", "{}: A-RELEASE-RP timeout expired", "{}: stop A-RELEASE-RP timeout", this.conn.getReleaseTimeout(), State.Sta7);
    }

    private void startIdleTimeout() {
        this.startTimeout("{}: start idle timeout of {}ms", "{}: idle timeout expired", "{}: stop idle timeout", this.conn.getIdleTimeout(), State.Sta6);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startTimeout(String startMsg, String expiredMsg, String cancelMsg, int timeout, State state) {
        if (timeout > 0 && this.performing == 0 && this.rspHandlerForMsgId.isEmpty()) {
            Association association = this;
            synchronized (association) {
                if (this.state == state) {
                    this.stopTimeout();
                    this.timeout = Timeout.start(this, startMsg, expiredMsg, cancelMsg, timeout);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startTimeout(int msgID, int timeout, boolean stopOnPending) {
        if (timeout > 0) {
            Capacity<DimseRSPHandler> capacity = this.rspHandlerForMsgId;
            synchronized (capacity) {
                DimseRSPHandler rspHandler = this.rspHandlerForMsgId.get(msgID);
                if (null != rspHandler) {
                    rspHandler.setTimeout(Timeout.start(this, "{}: start " + msgID + ":DIMSE-RSP timeout of {}ms", "{}: " + msgID + ":DIMSE-RSP timeout expired", "{}: stop " + msgID + ":DIMSE-RSP timeout", timeout), stopOnPending);
                }
            }
        }
    }

    private synchronized void stopTimeout() {
        if (null != this.timeout) {
            this.timeout.stop();
            this.timeout = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForOutstandingRSP() throws InterruptedException {
        Capacity<DimseRSPHandler> capacity = this.rspHandlerForMsgId;
        synchronized (capacity) {
            while (!this.rspHandlerForMsgId.isEmpty()) {
                this.rspHandlerForMsgId.wait();
            }
        }
    }

    void write(AAssociateRQ rq) throws IOException {
        this.name = rq.getCallingAET() + this.delim() + rq.getCalledAET() + "(" + this.serialNo + ")";
        this.rq = rq;
        Logger.info("{} << A-ASSOCIATE-RQ", this.name);
        Logger.debug("{}", rq);
        this.enterState(State.Sta5);
        this.encoder.write(rq);
        this.startAcceptTimeout();
    }

    private void write(AAssociateAC ac) throws IOException {
        Logger.info("{} << A-ASSOCIATE-AC", this.name);
        Logger.debug("{}", ac);
        this.enterState(State.Sta6);
        this.encoder.write(ac);
        this.startIdleTimeout();
    }

    private void write(AAssociateRJ rj) throws IOException {
        Logger.info("{} << {}", this.name, rj.toString());
        this.encoder.write(rj);
        this.closeSocketDelayed();
    }

    private void checkException() throws IOException {
        if (null != this.ex) {
            throw this.ex;
        }
    }

    private synchronized void enterState(State newState) {
        Logger.debug("{}: enter state: {}", new Object[]{this.name, newState});
        this.state = newState;
        this.notifyAll();
    }

    public final State getState() {
        return this.state;
    }

    synchronized void waitForLeaving(State state) throws InterruptedException, IOException {
        while (this.state == state) {
            this.wait();
        }
        this.checkException();
    }

    synchronized void waitForEntering(State state) throws InterruptedException, IOException {
        while (this.state != state) {
            this.wait();
        }
        this.checkException();
    }

    public void waitForSocketClose() throws InterruptedException, IOException {
        this.waitForEntering(State.Sta1);
    }

    private void activate() {
        this.device.execute(() -> {
            try {
                this.decoder = new PDUDecoder(this, this.in);
                this.device.addAssociation(this);
                while (this.state != State.Sta1 && this.state != State.Sta13) {
                    this.decoder.nextPDU();
                }
            }
            catch (AAbort aa) {
                this.abort(aa);
            }
            catch (IOException e) {
                this.onIOException(e);
            }
            catch (Exception e) {
                this.onIOException(new IOException("Unexpected Error", e));
            }
            finally {
                this.device.removeAssociation(this);
                this.onClose();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onClose() {
        this.stopTimeout();
        Capacity<DimseRSPHandler> capacity = this.rspHandlerForMsgId;
        synchronized (capacity) {
            Capacity.Visitor<DimseRSPHandler> visitor = (key, value) -> {
                value.onClose(this);
                return true;
            };
            this.rspHandlerForMsgId.accept(visitor);
            this.rspHandlerForMsgId.clear();
            this.rspHandlerForMsgId.notifyAll();
        }
        if (null != this.ae) {
            this.ae.getDevice().getAssociationHandler().onClose(this);
        }
        for (AssociationListener listener : this.listeners) {
            listener.onClose(this);
        }
    }

    public void onAAssociateRQ(AAssociateRQ rq) throws IOException {
        this.name = rq.getCalledAET() + this.delim() + rq.getCallingAET() + "(" + this.serialNo + ")";
        Logger.info("{} >> A-ASSOCIATE-RQ", this.name);
        Logger.debug("{}", rq);
        this.stopTimeout();
        this.state.onAAssociateRQ(this, rq);
    }

    void handle(AAssociateRQ rq) throws IOException {
        block3: {
            this.rq = rq;
            this.enterState(State.Sta3);
            try {
                this.ae = this.device.getApplicationEntity(rq.getCalledAET(), true);
                this.ac = this.device.getAssociationHandler().negotiate(this, rq);
                this.initPCMap();
                this.maxOpsInvoked = this.ac.getMaxOpsPerformed();
                this.maxPDULength = Association.minZeroAsMax(rq.getMaxPDULength(), this.conn.getSendPDULength());
                this.write(this.ac);
                if (null != this.monitor) {
                    this.monitor.onAssociationAccepted(this);
                }
            }
            catch (AAssociateRJ e) {
                this.write(e);
                if (null == this.monitor) break block3;
                this.monitor.onAssociationRejected(this, e);
            }
        }
    }

    public void onAAssociateAC(AAssociateAC ac) throws IOException {
        Logger.info("{} >> A-ASSOCIATE-AC", this.name);
        Logger.debug("{}", ac);
        this.stopTimeout();
        this.state.onAAssociateAC(this, ac);
    }

    void handle(AAssociateAC ac) {
        this.ac = ac;
        this.initPCMap();
        this.maxOpsInvoked = ac.getMaxOpsInvoked();
        this.maxPDULength = Association.minZeroAsMax(ac.getMaxPDULength(), this.conn.getSendPDULength());
        this.enterState(State.Sta6);
        this.startIdleTimeout();
    }

    public void onAAssociateRJ(AAssociateRJ rj) throws IOException {
        Logger.info("{} >> {}", this.name, rj);
        this.state.onAAssociateRJ(this, rj);
    }

    void handle(AAssociateRJ rq) {
        this.ex = rq;
        this.closeSocket();
    }

    public void onAReleaseRQ() throws IOException {
        Logger.info("{} >> A-RELEASE-RQ", this.name);
        this.stopTimeout();
        this.state.onAReleaseRQ(this);
    }

    void handleAReleaseRQ() throws IOException {
        if (this.decoder.isPendingPDV()) {
            Logger.info("{}: unexpected A-RELEASE-RQ after P-DATA-TF with pending PDV", this);
            this.abort();
            return;
        }
        this.enterState(State.Sta8);
        this.waitForPerformingOps();
        Logger.info("{} << A-RELEASE-RP", this.name);
        this.encoder.writeAReleaseRP();
        this.closeSocketDelayed();
    }

    private synchronized void waitForPerformingOps() {
        while (this.performing > 0 && this.state == State.Sta8) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    void handleAReleaseRQCollision() throws IOException {
        if (this.isRequestor()) {
            this.enterState(State.Sta9);
            Logger.info("{} << A-RELEASE-RP", this.name);
            this.encoder.writeAReleaseRP();
            this.enterState(State.Sta11);
        } else {
            this.enterState(State.Sta10);
        }
    }

    public void onAReleaseRP() throws IOException {
        Logger.info("{} >> A-RELEASE-RP", this.name);
        this.stopTimeout();
        this.state.onAReleaseRP(this);
    }

    void handleAReleaseRP() {
        this.closeSocket();
    }

    void handleAReleaseRPCollision() throws IOException {
        this.enterState(State.Sta12);
        Logger.info("{} << A-RELEASE-RP", this.name);
        this.encoder.writeAReleaseRP();
        this.closeSocketDelayed();
    }

    public void onAAbort(AAbort aa) {
        Logger.info("{} >> {}", this.name, aa);
        this.stopTimeout();
        this.ex = aa;
        this.closeSocket();
    }

    void unexpectedPDU(String pdu) throws AAbort {
        Logger.warn("{} >> unexpected {} in state: {}", new Object[]{this.name, pdu, this.state});
        throw new AAbort(2, 2);
    }

    public void onPDataTF() throws IOException {
        this.state.onPDataTF(this);
    }

    void handlePDataTF() throws IOException {
        this.decoder.decodeDIMSE();
    }

    public void writePDataTF() throws IOException {
        this.checkException();
        this.state.writePDataTF(this);
    }

    void doWritePDataTF() throws IOException {
        this.encoder.writePDataTF();
    }

    public void onDimseRQ(Presentation pc, Dimse dimse, Attributes cmd, PDVInputStream data) throws IOException {
        this.stopTimeout();
        this.incPerforming();
        this.incReceivedCount(dimse);
        this.ae.onDimseRQ(this, pc, dimse, cmd, data);
    }

    private synchronized void incPerforming() {
        ++this.performing;
    }

    private synchronized void decPerforming() {
        --this.performing;
        this.notifyAll();
    }

    public void onDimseRSP(Dimse dimse, Attributes cmd, Attributes data) throws AAbort {
        int msgId = cmd.getInt(288, -1);
        int status = cmd.getInt(2304, 0);
        boolean pending = Status.isPending(status);
        DimseRSPHandler rspHandler = this.getDimseRSPHandler(msgId);
        if (null == rspHandler) {
            Logger.info("{}: unexpected message ID in DIMSE RSP:", this.name);
            Logger.info("\n{}", cmd);
            throw new AAbort();
        }
        rspHandler.onDimseRSP(this, cmd, data);
        if (pending) {
            if (rspHandler.isStopOnPending()) {
                this.startTimeout(msgId, this.conn.getRetrieveTimeout(), true);
            }
        } else {
            this.incReceivedCount(dimse);
            this.removeDimseRSPHandler(msgId);
            if (this.rspHandlerForMsgId.isEmpty() && this.performing == 0) {
                this.startIdleOrReleaseTimeout();
            }
        }
    }

    private synchronized void startIdleOrReleaseTimeout() {
        if (this.state == State.Sta6) {
            this.startIdleTimeout();
        } else if (this.state == State.Sta7) {
            this.startReleaseTimeout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDimseRSPHandler(DimseRSPHandler rspHandler) throws InterruptedException {
        Capacity<DimseRSPHandler> capacity = this.rspHandlerForMsgId;
        synchronized (capacity) {
            while (this.maxOpsInvoked > 0 && this.rspHandlerForMsgId.size() >= this.maxOpsInvoked) {
                this.rspHandlerForMsgId.wait();
            }
            this.rspHandlerForMsgId.put(rspHandler.getMessageID(), rspHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DimseRSPHandler getDimseRSPHandler(int msgId) {
        Capacity<DimseRSPHandler> capacity = this.rspHandlerForMsgId;
        synchronized (capacity) {
            return this.rspHandlerForMsgId.get(msgId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DimseRSPHandler removeDimseRSPHandler(int msgId) {
        Capacity<DimseRSPHandler> capacity = this.rspHandlerForMsgId;
        synchronized (capacity) {
            DimseRSPHandler tmp = this.rspHandlerForMsgId.remove(msgId);
            this.rspHandlerForMsgId.notifyAll();
            return tmp;
        }
    }

    void cancel(Presentation pc, int msgId) throws IOException {
        Attributes cmd = Commands.mkCCancelRQ(msgId);
        this.encoder.writeDIMSE(pc, cmd, null);
    }

    public boolean tryWriteDimseRSP(Presentation pc, Attributes cmd) {
        return this.tryWriteDimseRSP(pc, cmd, null);
    }

    public boolean tryWriteDimseRSP(Presentation pc, Attributes cmd, Attributes data) {
        try {
            this.writeDimseRSP(pc, cmd, data);
            return true;
        }
        catch (IOException e) {
            Logger.warn("{} << {} failed: {}", new Object[]{this, Dimse.valueOf(cmd.getInt(256, 0)), e.getMessage()});
            return false;
        }
    }

    public void writeDimseRSP(Presentation pc, Attributes cmd) throws IOException {
        this.writeDimseRSP(pc, cmd, null);
    }

    public void writeDimseRSP(Presentation pc, Attributes cmd, Attributes data) throws IOException {
        DataWriterAdapter writer = null;
        int datasetType = 257;
        if (null != data) {
            writer = new DataWriterAdapter(data);
            datasetType = Commands.getWithDatasetType();
        }
        cmd.setInt(2048, VR.US, datasetType);
        this.encoder.writeDIMSE(pc, cmd, writer);
        if (!Status.isPending(cmd.getInt(2304, 0))) {
            this.decPerforming();
            this.startIdleTimeout();
        }
    }

    public void onCancelRQ(Attributes cmd) {
        this.incReceivedCount(Dimse.C_CANCEL_RQ);
        int msgId = cmd.getInt(288, -1);
        CancelRQHandler handler = this.removeCancelRQHandler(msgId);
        if (null != handler) {
            handler.onCancelRQ(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCancelRQHandler(int msgId, CancelRQHandler handler) {
        Capacity<CancelRQHandler> capacity = this.cancelHandlerForMsgId;
        synchronized (capacity) {
            this.cancelHandlerForMsgId.put(msgId, handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CancelRQHandler removeCancelRQHandler(int msgId) {
        Capacity<CancelRQHandler> capacity = this.cancelHandlerForMsgId;
        synchronized (capacity) {
            return this.cancelHandlerForMsgId.remove(msgId);
        }
    }

    private void initPCMap() {
        for (Presentation pc : this.ac.getPresentationContexts()) {
            if (!pc.isAccepted()) continue;
            Presentation rqpc = this.rq.getPresentationContext(pc.getPCID());
            if (null != rqpc) {
                this.initTSMap(rqpc.getAbstractSyntax()).put(pc.getTransferSyntax(), pc);
                continue;
            }
            Logger.info("{}: Ignore unexpected {} in A-ASSOCIATE-AC", this.name, pc);
        }
    }

    private Map<String, Presentation> initTSMap(String as) {
        Map<String, Presentation> tsMap = this.pcMap.get(as);
        if (null == tsMap) {
            tsMap = new HashMap<String, Presentation>();
            this.pcMap.put(as, tsMap);
        }
        return tsMap;
    }

    public Presentation pcFor(String cuid, String tsuid) throws InstrumentException {
        Map<String, Presentation> tsMap = this.pcMap.get(cuid);
        if (null == tsMap) {
            throw new InstrumentException(cuid);
        }
        if (null == tsuid) {
            return tsMap.values().iterator().next();
        }
        Presentation pc = tsMap.get(tsuid);
        if (null == pc) {
            throw new InstrumentException(cuid, tsuid);
        }
        return pc;
    }

    public Set<String> getTransferSyntaxesFor(String cuid) {
        Map<String, Presentation> tsMap = this.pcMap.get(cuid);
        if (null == tsMap) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(tsMap.keySet());
    }

    public Presentation getPresentationContext(int pcid) {
        return this.ac.getPresentationContext(pcid);
    }

    public CommonExtended getCommonExtendedNegotiationFor(String cuid) {
        return this.ac.getCommonExtendedNegotiationFor(cuid);
    }

    public void cstore(String cuid, String iuid, int priority, DataWriter data, String tsuid, DimseRSPHandler rspHandler) throws IOException, InterruptedException {
        Presentation pc = this.pcFor(cuid, tsuid);
        this.checkIsSCU(cuid);
        Attributes cstorerq = Commands.mkCStoreRQ(rspHandler.getMessageID(), cuid, iuid, priority);
        this.invoke(pc, cstorerq, data, rspHandler, this.conn.getResponseTimeout());
    }

    public DimseRSP cstore(String cuid, String iuid, int priority, DataWriter data, String tsuid) throws IOException, InterruptedException {
        FutureDimseRSP rsp = new FutureDimseRSP(this.nextMessageID());
        this.cstore(cuid, iuid, priority, data, tsuid, rsp);
        return rsp;
    }

    public void cstore(String cuid, String iuid, int priority, String moveOriginatorAET, int moveOriginatorMsgId, DataWriter data, String tsuid, DimseRSPHandler rspHandler) throws IOException, InterruptedException {
        Presentation pc = this.pcFor(cuid, tsuid);
        Attributes cstorerq = Commands.mkCStoreRQ(rspHandler.getMessageID(), cuid, iuid, priority, moveOriginatorAET, moveOriginatorMsgId);
        this.invoke(pc, cstorerq, data, rspHandler, this.conn.getResponseTimeout());
    }

    public DimseRSP cstore(String cuid, String iuid, int priority, String moveOriginatorAET, int moveOriginatorMsgId, DataWriter data, String tsuid) throws IOException, InterruptedException {
        FutureDimseRSP rsp = new FutureDimseRSP(this.nextMessageID());
        this.cstore(cuid, iuid, priority, moveOriginatorAET, moveOriginatorMsgId, data, tsuid, rsp);
        return rsp;
    }

    public void cfind(String cuid, int priority, Attributes data, String tsuid, DimseRSPHandler rspHandler) throws IOException, InterruptedException {
        Presentation pc = this.pcFor(cuid, tsuid);
        this.checkIsSCU(cuid);
        Attributes cfindrq = Commands.mkCFindRQ(rspHandler.getMessageID(), cuid, priority);
        this.invoke(pc, cfindrq, new DataWriterAdapter(data), rspHandler, this.conn.getResponseTimeout());
    }

    public DimseRSP cfind(String cuid, int priority, Attributes data, String tsuid, int autoCancel) throws IOException, InterruptedException {
        return this.cfind(cuid, priority, data, tsuid, autoCancel, Integer.MAX_VALUE);
    }

    public DimseRSP cfind(String cuid, int priority, Attributes data, String tsuid, int autoCancel, int capacity) throws IOException, InterruptedException {
        FutureDimseRSP rsp = new FutureDimseRSP(this.nextMessageID());
        rsp.setAutoCancel(autoCancel);
        rsp.setCapacity(capacity);
        this.cfind(cuid, priority, data, tsuid, rsp);
        return rsp;
    }

    public void cget(String cuid, int priority, Attributes data, String tsuid, DimseRSPHandler rspHandler) throws IOException, InterruptedException {
        Presentation pc = this.pcFor(cuid, tsuid);
        this.checkIsSCU(cuid);
        Attributes cgetrq = Commands.mkCGetRQ(rspHandler.getMessageID(), cuid, priority);
        this.invoke(pc, cgetrq, new DataWriterAdapter(data), rspHandler, this.conn.getRetrieveTimeout(), !this.conn.isRetrieveTimeoutTotal());
    }

    public DimseRSP cget(String cuid, int priority, Attributes data, String tsuid) throws IOException, InterruptedException {
        FutureDimseRSP rsp = new FutureDimseRSP(this.nextMessageID());
        this.cget(cuid, priority, data, tsuid, rsp);
        return rsp;
    }

    public void cmove(String cuid, int priority, Attributes data, String tsuid, String destination, DimseRSPHandler rspHandler) throws IOException, InterruptedException {
        Presentation pc = this.pcFor(cuid, tsuid);
        this.checkIsSCU(cuid);
        Attributes cmoverq = Commands.mkCMoveRQ(rspHandler.getMessageID(), cuid, priority, destination);
        this.invoke(pc, cmoverq, new DataWriterAdapter(data), rspHandler, this.conn.getRetrieveTimeout(), !this.conn.isRetrieveTimeoutTotal());
    }

    public DimseRSP cmove(String cuid, int priority, Attributes data, String tsuid, String destination) throws IOException, InterruptedException {
        FutureDimseRSP rsp = new FutureDimseRSP(this.nextMessageID());
        this.cmove(cuid, priority, data, tsuid, destination, rsp);
        return rsp;
    }

    public DimseRSP cecho() throws IOException, InterruptedException {
        return this.cecho("1.2.840.10008.1.1");
    }

    public DimseRSP cecho(String cuid) throws IOException, InterruptedException {
        FutureDimseRSP rsp = new FutureDimseRSP(this.nextMessageID());
        Presentation pc = this.pcFor(cuid, null);
        this.checkIsSCU(cuid);
        Attributes cechorq = Commands.mkCEchoRQ(rsp.getMessageID(), cuid);
        this.invoke(pc, cechorq, null, rsp, this.conn.getResponseTimeout());
        return rsp;
    }

    public void neventReport(String cuid, String iuid, int eventTypeId, Attributes data, String tsuid, DimseRSPHandler rspHandler) throws IOException, InterruptedException {
        this.neventReport(cuid, cuid, iuid, eventTypeId, data, tsuid, rspHandler);
    }

    public void neventReport(String asuid, String cuid, String iuid, int eventTypeId, Attributes data, String tsuid, DimseRSPHandler rspHandler) throws IOException, InterruptedException {
        Presentation pc = this.pcFor(asuid, tsuid);
        this.checkIsSCP(cuid);
        Attributes neventrq = Commands.mkNEventReportRQ(rspHandler.getMessageID(), cuid, iuid, eventTypeId, data);
        this.invoke(pc, neventrq, DataWriterAdapter.forAttributes(data), rspHandler, this.conn.getResponseTimeout());
    }

    public DimseRSP neventReport(String cuid, String iuid, int eventTypeId, Attributes data, String tsuid) throws IOException, InterruptedException {
        return this.neventReport(cuid, cuid, iuid, eventTypeId, data, tsuid);
    }

    public DimseRSP neventReport(String asuid, String cuid, String iuid, int eventTypeId, Attributes data, String tsuid) throws IOException, InterruptedException {
        FutureDimseRSP rsp = new FutureDimseRSP(this.nextMessageID());
        this.neventReport(asuid, cuid, iuid, eventTypeId, data, tsuid, rsp);
        return rsp;
    }

    public void nget(String cuid, String iuid, int[] tags, DimseRSPHandler rspHandler) throws IOException, InterruptedException {
        this.nget(cuid, cuid, iuid, tags, rspHandler);
    }

    public void nget(String asuid, String cuid, String iuid, int[] tags, DimseRSPHandler rspHandler) throws IOException, InterruptedException {
        Presentation pc = this.pcFor(asuid, null);
        this.checkIsSCU(cuid);
        Attributes ngetrq = Commands.mkNGetRQ(rspHandler.getMessageID(), cuid, iuid, tags);
        this.invoke(pc, ngetrq, null, rspHandler, this.conn.getResponseTimeout());
    }

    public DimseRSP nget(String cuid, String iuid, int[] tags) throws IOException, InterruptedException {
        return this.nget(cuid, cuid, iuid, tags);
    }

    public DimseRSP nget(String asuid, String cuid, String iuid, int[] tags) throws IOException, InterruptedException {
        FutureDimseRSP rsp = new FutureDimseRSP(this.nextMessageID());
        this.nget(asuid, cuid, iuid, tags, rsp);
        return rsp;
    }

    public void nset(String cuid, String iuid, Attributes data, String tsuid, DimseRSPHandler rspHandler) throws IOException, InterruptedException {
        this.nset(cuid, cuid, iuid, new DataWriterAdapter(data), tsuid, rspHandler);
    }

    public void nset(String asuid, String cuid, String iuid, Attributes data, String tsuid, DimseRSPHandler rspHandler) throws IOException, InterruptedException {
        this.nset(asuid, cuid, iuid, new DataWriterAdapter(data), tsuid, rspHandler);
    }

    public DimseRSP nset(String cuid, String iuid, Attributes data, String tsuid) throws IOException, InterruptedException {
        return this.nset(cuid, cuid, iuid, new DataWriterAdapter(data), tsuid);
    }

    public DimseRSP nset(String asuid, String cuid, String iuid, Attributes data, String tsuid) throws IOException, InterruptedException {
        return this.nset(asuid, cuid, iuid, new DataWriterAdapter(data), tsuid);
    }

    public void nset(String cuid, String iuid, DataWriter data, String tsuid, DimseRSPHandler rspHandler) throws IOException, InterruptedException {
        this.nset(cuid, cuid, iuid, data, tsuid, rspHandler);
    }

    public void nset(String asuid, String cuid, String iuid, DataWriter data, String tsuid, DimseRSPHandler rspHandler) throws IOException, InterruptedException {
        Presentation pc = this.pcFor(asuid, tsuid);
        this.checkIsSCU(cuid);
        Attributes nsetrq = Commands.mkNSetRQ(rspHandler.getMessageID(), cuid, iuid);
        this.invoke(pc, nsetrq, data, rspHandler, this.conn.getResponseTimeout());
    }

    public DimseRSP nset(String cuid, String iuid, DataWriter data, String tsuid) throws IOException, InterruptedException {
        return this.nset(cuid, cuid, iuid, data, tsuid);
    }

    public DimseRSP nset(String asuid, String cuid, String iuid, DataWriter data, String tsuid) throws IOException, InterruptedException {
        FutureDimseRSP rsp = new FutureDimseRSP(this.nextMessageID());
        this.nset(asuid, cuid, iuid, data, tsuid, (DimseRSPHandler)rsp);
        return rsp;
    }

    public void naction(String cuid, String iuid, int actionTypeId, Attributes data, String tsuid, DimseRSPHandler rspHandler) throws IOException, InterruptedException {
        this.naction(cuid, cuid, iuid, actionTypeId, data, tsuid, rspHandler);
    }

    public void naction(String asuid, String cuid, String iuid, int actionTypeId, Attributes data, String tsuid, DimseRSPHandler rspHandler) throws IOException, InterruptedException {
        Presentation pc = this.pcFor(asuid, tsuid);
        this.checkIsSCU(cuid);
        Attributes nactionrq = Commands.mkNActionRQ(rspHandler.getMessageID(), cuid, iuid, actionTypeId, data);
        this.invoke(pc, nactionrq, DataWriterAdapter.forAttributes(data), rspHandler, this.conn.getResponseTimeout());
    }

    public DimseRSP naction(String cuid, String iuid, int actionTypeId, Attributes data, String tsuid) throws IOException, InterruptedException {
        return this.naction(cuid, cuid, iuid, actionTypeId, data, tsuid);
    }

    public DimseRSP naction(String asuid, String cuid, String iuid, int actionTypeId, Attributes data, String tsuid) throws IOException, InterruptedException {
        FutureDimseRSP rsp = new FutureDimseRSP(this.nextMessageID());
        this.naction(asuid, cuid, iuid, actionTypeId, data, tsuid, rsp);
        return rsp;
    }

    public void ncreate(String cuid, String iuid, Attributes data, String tsuid, DimseRSPHandler rspHandler) throws IOException, InterruptedException {
        this.ncreate(cuid, cuid, iuid, data, tsuid, rspHandler);
    }

    public void ncreate(String asuid, String cuid, String iuid, Attributes data, String tsuid, DimseRSPHandler rspHandler) throws IOException, InterruptedException {
        Presentation pc = this.pcFor(asuid, tsuid);
        this.checkIsSCU(cuid);
        Attributes ncreaterq = Commands.mkNCreateRQ(rspHandler.getMessageID(), cuid, iuid);
        this.invoke(pc, ncreaterq, DataWriterAdapter.forAttributes(data), rspHandler, this.conn.getResponseTimeout());
    }

    public DimseRSP ncreate(String cuid, String iuid, Attributes data, String tsuid) throws IOException, InterruptedException {
        return this.ncreate(cuid, cuid, iuid, data, tsuid);
    }

    public DimseRSP ncreate(String asuid, String cuid, String iuid, Attributes data, String tsuid) throws IOException, InterruptedException {
        FutureDimseRSP rsp = new FutureDimseRSP(this.nextMessageID());
        this.ncreate(asuid, cuid, iuid, data, tsuid, rsp);
        return rsp;
    }

    public void ndelete(String cuid, String iuid, DimseRSPHandler rspHandler) throws IOException, InterruptedException {
        this.ndelete(cuid, cuid, iuid, rspHandler);
    }

    public void ndelete(String asuid, String cuid, String iuid, DimseRSPHandler rspHandler) throws IOException, InterruptedException {
        Presentation pc = this.pcFor(asuid, null);
        this.checkIsSCU(cuid);
        Attributes ndeleterq = Commands.mkNDeleteRQ(rspHandler.getMessageID(), cuid, iuid);
        this.invoke(pc, ndeleterq, null, rspHandler, this.conn.getResponseTimeout());
    }

    public DimseRSP ndelete(String cuid, String iuid) throws IOException, InterruptedException {
        return this.ndelete(cuid, cuid, iuid);
    }

    public DimseRSP ndelete(String asuid, String cuid, String iuid) throws IOException, InterruptedException {
        FutureDimseRSP rsp = new FutureDimseRSP(this.nextMessageID());
        this.ndelete(asuid, cuid, iuid, rsp);
        return rsp;
    }

    public void invoke(Presentation pc, Attributes cmd, DataWriter data, DimseRSPHandler rspHandler, int rspTimeout) throws IOException, InterruptedException {
        this.invoke(pc, cmd, data, rspHandler, rspTimeout, true);
    }

    public void invoke(Presentation pc, Attributes cmd, DataWriter data, DimseRSPHandler rspHandler, int rspTimeout, boolean stopOnPending) throws IOException, InterruptedException {
        this.stopTimeout();
        this.checkException();
        rspHandler.setPC(pc);
        this.addDimseRSPHandler(rspHandler);
        this.encoder.writeDIMSE(pc, cmd, data);
        this.startTimeout(rspHandler.getMessageID(), rspTimeout, stopOnPending);
    }

    public Attributes createFileMetaInformation(String iuid, String cuid, String tsuid) {
        Attributes fmi = new Attributes(7);
        fmi.setBytes(131073, VR.OB, new byte[]{0, 1});
        fmi.setString(131074, VR.UI, cuid);
        fmi.setString(131075, VR.UI, iuid);
        fmi.setString(131088, VR.UI, tsuid);
        fmi.setString(131090, VR.UI, this.getRemoteImplClassUID());
        String versionName = this.getRemoteImplVersionName();
        if (null != versionName) {
            fmi.setString(131091, VR.SH, versionName);
        }
        fmi.setString(131094, VR.AE, this.getRemoteAET());
        return fmi;
    }

    public EnumSet<Option.Type> getQueryOptionsFor(String cuid) {
        return Option.Type.toOptions(this.ac.getExtNegotiationFor(cuid));
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum State {
        Sta1("Sta1 - Idle"){

            @Override
            void write(Association as, AAbort aa) {
            }

            @Override
            void closeSocket(Association as) {
            }

            @Override
            void closeSocketDelayed(Association as) {
            }
        }
        ,
        Sta2("Sta2 - Transport connection open"){

            @Override
            void onAAssociateRQ(Association as, AAssociateRQ rq) throws IOException {
                as.handle(rq);
            }
        }
        ,
        Sta3("Sta3 - Awaiting local A-ASSOCIATE response primitive"),
        Sta4("Sta4 - Awaiting transport connection opening to complete"),
        Sta5("Sta5 - Awaiting A-ASSOCIATE-AC or A-ASSOCIATE-RJ PDU"){

            @Override
            void onAAssociateAC(Association as, AAssociateAC ac) throws IOException {
                as.handle(ac);
            }

            @Override
            void onAAssociateRJ(Association as, AAssociateRJ rj) throws IOException {
                as.handle(rj);
            }
        }
        ,
        Sta6("Sta6 - Association established and ready for data transfer"){

            @Override
            void onAReleaseRQ(Association as) throws IOException {
                as.handleAReleaseRQ();
            }

            @Override
            void onPDataTF(Association as) throws IOException {
                as.handlePDataTF();
            }

            @Override
            void writeAReleaseRQ(Association as) throws IOException {
                as.writeAReleaseRQ();
            }

            @Override
            public void writePDataTF(Association as) throws IOException {
                as.doWritePDataTF();
            }
        }
        ,
        Sta7("Sta7 - Awaiting A-RELEASE-RP PDU"){

            @Override
            public void onAReleaseRP(Association as) throws IOException {
                as.handleAReleaseRP();
            }

            @Override
            void onAReleaseRQ(Association as) throws IOException {
                as.handleAReleaseRQCollision();
            }

            @Override
            void onPDataTF(Association as) throws IOException {
                as.handlePDataTF();
            }
        }
        ,
        Sta8("Sta8 - Awaiting local A-RELEASE response primitive"){

            @Override
            public void writePDataTF(Association as) throws IOException {
                as.doWritePDataTF();
            }
        }
        ,
        Sta9("Sta9 - Release collision requestor side; awaiting A-RELEASE response"),
        Sta10("Sta10 - Release collision acceptor side; awaiting A-RELEASE-RP PDU"){

            @Override
            void onAReleaseRP(Association as) throws IOException {
                as.handleAReleaseRPCollision();
            }
        }
        ,
        Sta11("Sta11 - Release collision requestor side; awaiting A-RELEASE-RP PDU"){

            @Override
            void onAReleaseRP(Association as) throws IOException {
                as.handleAReleaseRP();
            }
        }
        ,
        Sta12("Sta12 - Release collision acceptor side; awaiting A-RELEASE response primitive"),
        Sta13("Sta13 - Awaiting Transport Connection Close Indication"){

            @Override
            public void onAReleaseRP(Association as) throws IOException {
            }

            @Override
            void onAReleaseRQ(Association as) throws IOException {
            }

            @Override
            void onPDataTF(Association as) throws IOException {
            }

            @Override
            void write(Association as, AAbort aa) {
            }

            @Override
            void closeSocketDelayed(Association as) {
            }
        };

        private final String name;

        private State(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        void onAAssociateRQ(Association as, AAssociateRQ rq) throws IOException {
            as.unexpectedPDU("A-ASSOCIATE-RQ");
        }

        void onAAssociateAC(Association as, AAssociateAC ac) throws IOException {
            as.unexpectedPDU("A-ASSOCIATE-AC");
        }

        void onAAssociateRJ(Association as, AAssociateRJ rj) throws IOException {
            as.unexpectedPDU("A-ASSOCIATE-RJ");
        }

        void onPDataTF(Association as) throws IOException {
            as.unexpectedPDU("P-DATA-TF");
        }

        void onAReleaseRQ(Association as) throws IOException {
            as.unexpectedPDU("A-RELEASE-RQ");
        }

        void onAReleaseRP(Association as) throws IOException {
            as.unexpectedPDU("A-RELEASE-RP");
        }

        void writeAReleaseRQ(Association as) throws IOException {
            throw new InstrumentException(this.toString());
        }

        void write(Association as, AAbort aa) throws IOException {
            as.write(aa);
        }

        public void writePDataTF(Association as) throws IOException {
            throw new InstrumentException(this.toString());
        }

        void closeSocket(Association as) {
            as.doCloseSocket();
        }

        void closeSocketDelayed(Association as) {
            as.doCloseSocketDelayed();
        }
    }
}

