/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.plugin;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.image.galaxy.io.BasicBulkDataDescriptor;
import org.aoju.bus.image.galaxy.io.ImageInputStream;
import org.aoju.bus.image.galaxy.io.SAXWriter;

public class Dcm2Xml {
    private static final String XML_1_0 = "1.0";
    private static final String XML_1_1 = "1.1";
    private final BasicBulkDataDescriptor bulkDataDescriptor = new BasicBulkDataDescriptor();
    private String xsltURL;
    private boolean indent = false;
    private boolean includeKeyword = true;
    private boolean includeNamespaceDeclaration = false;
    private ImageInputStream.IncludeBulkData includeBulkData = ImageInputStream.IncludeBulkData.URI;
    private boolean catBlkFiles = false;
    private String blkFilePrefix = "blk";
    private String blkFileSuffix;
    private File blkDirectory;
    private String xmlVersion = "1.0";

    private static String toURL(String fileOrURL) {
        try {
            new URL(fileOrURL);
            return fileOrURL;
        }
        catch (MalformedURLException e) {
            return new File(fileOrURL).toURI().toString();
        }
    }

    private static String fname(List<String> argList) throws InstrumentException {
        int numArgs = argList.size();
        if (numArgs == 0) {
            throw new InstrumentException("missing file operand");
        }
        if (numArgs > 1) {
            throw new InstrumentException("too many arguments");
        }
        return argList.get(0);
    }

    public final void setXSLTURL(String xsltURL) {
        this.xsltURL = xsltURL;
    }

    public final void setIndent(boolean indent) {
        this.indent = indent;
    }

    public final void setIncludeKeyword(boolean includeKeyword) {
        this.includeKeyword = includeKeyword;
    }

    public final void setIncludeNamespaceDeclaration(boolean includeNamespaceDeclaration) {
        this.includeNamespaceDeclaration = includeNamespaceDeclaration;
    }

    public final void setIncludeBulkData(ImageInputStream.IncludeBulkData includeBulkData) {
        this.includeBulkData = includeBulkData;
    }

    public final void setConcatenateBulkDataFiles(boolean catBlkFiles) {
        this.catBlkFiles = catBlkFiles;
    }

    public final void setBulkDataFilePrefix(String blkFilePrefix) {
        this.blkFilePrefix = blkFilePrefix;
    }

    public final void setBulkDataFileSuffix(String blkFileSuffix) {
        this.blkFileSuffix = blkFileSuffix;
    }

    public final void setBulkDataDirectory(File blkDirectory) {
        this.blkDirectory = blkDirectory;
    }

    public void setBulkDataNoDefaults(boolean excludeDefaults) {
        this.bulkDataDescriptor.excludeDefaults(excludeDefaults);
    }

    public void setBulkDataLengthsThresholdsFromStrings(String[] thresholds) {
        this.bulkDataDescriptor.setLengthsThresholdsFromStrings(thresholds);
    }

    public final void setXMLVersion(String xmlVersion) {
        this.xmlVersion = xmlVersion;
    }

    public void parse(ImageInputStream dis) throws IOException, TransformerConfigurationException {
        dis.setIncludeBulkData(this.includeBulkData);
        dis.setBulkDataDescriptor(this.bulkDataDescriptor);
        dis.setBulkDataDirectory(this.blkDirectory);
        dis.setBulkDataFilePrefix(this.blkFilePrefix);
        dis.setBulkDataFileSuffix(this.blkFileSuffix);
        dis.setConcatenateBulkDataFiles(this.catBlkFiles);
        TransformerHandler th = this.getTransformerHandler();
        Transformer t = th.getTransformer();
        t.setOutputProperty("indent", this.indent ? "yes" : "no");
        t.setOutputProperty("version", this.xmlVersion);
        th.setResult(new StreamResult(System.out));
        SAXWriter saxWriter = new SAXWriter(th);
        saxWriter.setIncludeKeyword(this.includeKeyword);
        saxWriter.setIncludeNamespaceDeclaration(this.includeNamespaceDeclaration);
        dis.setImageInputHandler(saxWriter);
        dis.readDataset(-1, -1);
    }

    private TransformerHandler getTransformerHandler() throws TransformerConfigurationException {
        SAXTransformerFactory tf = (SAXTransformerFactory)TransformerFactory.newInstance();
        if (null == this.xsltURL) {
            return tf.newTransformerHandler();
        }
        TransformerHandler th = tf.newTransformerHandler(new StreamSource(this.xsltURL));
        return th;
    }
}

