/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.mapper.builder.resolve;

import java.text.MessageFormat;
import java.util.LinkedHashSet;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.text.NamingCase;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.mapper.annotation.ColumnType;
import org.aoju.bus.mapper.annotation.KeySql;
import org.aoju.bus.mapper.annotation.NameStyle;
import org.aoju.bus.mapper.builder.FieldBuilder;
import org.aoju.bus.mapper.builder.resolve.EntityResolve;
import org.aoju.bus.mapper.criteria.Identity;
import org.aoju.bus.mapper.criteria.Order;
import org.aoju.bus.mapper.criteria.SimpleType;
import org.aoju.bus.mapper.criteria.Style;
import org.aoju.bus.mapper.criteria.Words;
import org.aoju.bus.mapper.entity.Config;
import org.aoju.bus.mapper.entity.EntityColumn;
import org.aoju.bus.mapper.entity.EntityField;
import org.aoju.bus.mapper.entity.EntityTable;
import org.aoju.bus.mapper.genid.GenId;
import org.aoju.bus.mapper.gensql.GenSql;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.UnknownTypeHandler;

public class DefaultEntityResolve
implements EntityResolve {
    private final Log log = LogFactory.getLog(DefaultEntityResolve.class);

    public static String convertByStyle(String text, Style style) {
        switch (style) {
            case camelhump: {
                return NamingCase.toUnderlineCase(text);
            }
            case uppercase: {
                return text.toUpperCase();
            }
            case lowercase: {
                return text.toLowerCase();
            }
            case camelhumpAndLowercase: {
                return NamingCase.toUnderlineCase(text).toLowerCase();
            }
            case camelhumpAndUppercase: {
                return NamingCase.toUnderlineCase(text).toUpperCase();
            }
        }
        return text;
    }

    @Override
    public EntityTable resolveEntity(Class<?> entityClass, Config config) {
        Table table;
        Style style = config.getStyle();
        if (entityClass.isAnnotationPresent(NameStyle.class)) {
            NameStyle nameStyle = entityClass.getAnnotation(NameStyle.class);
            style = nameStyle.value();
        }
        EntityTable entityTable = null;
        if (entityClass.isAnnotationPresent(Table.class) && !"".equals((table = entityClass.getAnnotation(Table.class)).name())) {
            entityTable = new EntityTable(entityClass);
            entityTable.setTable(table);
        }
        if (entityTable == null) {
            entityTable = new EntityTable(entityClass);
            String tableName = DefaultEntityResolve.convertByStyle(entityClass.getSimpleName(), style);
            if (StringKit.isNotEmpty(config.getWrapKeyword()) && Words.containsWord(tableName)) {
                tableName = MessageFormat.format(config.getWrapKeyword(), tableName);
            }
            entityTable.setName(tableName);
        }
        entityTable.setEntityClassColumns(new LinkedHashSet<EntityColumn>());
        entityTable.setEntityClassPKColumns(new LinkedHashSet<EntityColumn>());
        List<EntityField> fields = config.isEnableMethodAnnotation() ? FieldBuilder.getAll(entityClass) : FieldBuilder.getFields(entityClass);
        for (EntityField field : fields) {
            if (config.isUseSimpleType() && !field.isAnnotationPresent(Column.class) && !field.isAnnotationPresent(ColumnType.class) && !SimpleType.isSimpleType(field.getJavaType()) && (!config.isEnumAsSimpleType() || !Enum.class.isAssignableFrom(field.getJavaType()))) continue;
            this.processField(entityTable, field, config, style);
        }
        if (entityTable.getEntityClassPKColumns().size() == 0) {
            entityTable.setEntityClassPKColumns(entityTable.getEntityClassColumns());
        }
        entityTable.initPropertyMap();
        return entityTable;
    }

    protected void processField(EntityTable entityTable, EntityField field, Config config, Style style) {
        if (field.isAnnotationPresent(Transient.class)) {
            return;
        }
        EntityColumn entityColumn = new EntityColumn(entityTable);
        entityColumn.setUseJavaType(config.isUseJavaType());
        entityColumn.setEntityField(field);
        if (field.isAnnotationPresent(Id.class)) {
            entityColumn.setId(true);
        }
        String columnName = null;
        if (field.isAnnotationPresent(Column.class)) {
            Column column = field.getAnnotation(Column.class);
            columnName = column.name();
            entityColumn.setUpdatable(column.updatable());
            entityColumn.setInsertable(column.insertable());
        }
        if (field.isAnnotationPresent(ColumnType.class)) {
            ColumnType columnType = field.getAnnotation(ColumnType.class);
            entityColumn.setBlob(columnType.isBlob());
            if (StringKit.isEmpty(columnName) && StringKit.isNotEmpty(columnType.column())) {
                columnName = columnType.column();
            }
            if (columnType.jdbcType() != JdbcType.UNDEFINED) {
                entityColumn.setJdbcType(columnType.jdbcType());
            }
            if (columnType.typeHandler() != UnknownTypeHandler.class) {
                entityColumn.setTypeHandler(columnType.typeHandler());
            }
        }
        if (StringKit.isEmpty(columnName)) {
            columnName = DefaultEntityResolve.convertByStyle(field.getName(), style);
        }
        if (StringKit.isNotEmpty(config.getWrapKeyword()) && Words.containsWord(columnName)) {
            columnName = MessageFormat.format(config.getWrapKeyword(), columnName);
        }
        entityColumn.setProperty(field.getName());
        entityColumn.setColumn(columnName);
        entityColumn.setJavaType(field.getJavaType());
        if (field.getJavaType().isPrimitive()) {
            this.log.warn("\u901a\u7528 Mapper \u8b66\u544a\u4fe1\u606f: <[" + entityColumn + "]> \u4f7f\u7528\u4e86\u57fa\u672c\u7c7b\u578b\uff0c\u57fa\u672c\u7c7b\u578b\u5728\u52a8\u6001 SQL \u4e2d\u7531\u4e8e\u5b58\u5728\u9ed8\u8ba4\u503c\uff0c\u56e0\u6b64\u4efb\u4f55\u65f6\u5019\u90fd\u4e0d\u7b49\u4e8e null\uff0c\u5efa\u8bae\u4fee\u6539\u57fa\u672c\u7c7b\u578b\u4e3a\u5bf9\u5e94\u7684\u5305\u88c5\u7c7b\u578b!");
        }
        this.processOrderBy(entityTable, field, entityColumn);
        this.processKeyGenerator(entityTable, field, entityColumn);
        entityTable.getEntityClassColumns().add(entityColumn);
        if (entityColumn.isId()) {
            entityTable.getEntityClassPKColumns().add(entityColumn);
        }
    }

    protected void processOrderBy(EntityTable entityTable, EntityField field, EntityColumn entityColumn) {
        String orderBy = "";
        if (field.isAnnotationPresent(OrderBy.class)) {
            orderBy = field.getAnnotation(OrderBy.class).value();
            if ("".equals(orderBy)) {
                orderBy = "ASC";
            }
            this.log.warn(OrderBy.class + " is outdated, use " + org.aoju.bus.mapper.annotation.Order.class + " instead!");
        }
        if (field.isAnnotationPresent(org.aoju.bus.mapper.annotation.Order.class)) {
            org.aoju.bus.mapper.annotation.Order order = field.getAnnotation(org.aoju.bus.mapper.annotation.Order.class);
            orderBy = "".equals(order.value()) && "".equals(orderBy) ? "ASC" : order.value();
            entityColumn.setOrderPriority(order.priority());
        }
        if (StringKit.isNotEmpty(orderBy)) {
            entityColumn.setOrderBy(orderBy);
        }
    }

    protected void processKeyGenerator(EntityTable entityTable, EntityField field, EntityColumn entityColumn) {
        if (field.isAnnotationPresent(KeySql.class)) {
            this.processKeySql(entityTable, entityColumn, field.getAnnotation(KeySql.class));
        } else if (field.isAnnotationPresent(GeneratedValue.class)) {
            this.processGeneratedValue(entityTable, entityColumn, field.getAnnotation(GeneratedValue.class));
        }
    }

    protected void processGeneratedValue(EntityTable entityTable, EntityColumn entityColumn, GeneratedValue generatedValue) {
        if ("JDBC".equals(generatedValue.generator())) {
            entityColumn.setIdentity(true);
            entityColumn.setGenerator("JDBC");
            entityTable.setKeyProperties(entityColumn.getProperty());
            entityTable.setKeyColumns(entityColumn.getColumn());
        } else if (generatedValue.strategy() == GenerationType.IDENTITY) {
            entityColumn.setIdentity(true);
            if (!"".equals(generatedValue.generator())) {
                Identity identity = Identity.getDatabaseDialect(generatedValue.generator());
                String generator = identity != null ? identity.getIdentityRetrievalStatement() : generatedValue.generator();
                entityColumn.setGenerator(generator);
            }
        } else {
            throw new InstrumentException(entityColumn.getProperty() + " - \u8be5\u5b57\u6bb5@GeneratedValue\u914d\u7f6e\u53ea\u5141\u8bb8\u4ee5\u4e0b\u51e0\u79cd\u5f62\u5f0f:\n1.useGeneratedKeys\u7684@GeneratedValue(generator=\\\"JDBC\\\")  \n2.\u7c7b\u4f3cmysql\u6570\u636e\u5e93\u7684@GeneratedValue(strategy=GenerationType.IDENTITY[,generator=\"Mysql\"])");
        }
    }

    protected void processKeySql(EntityTable entityTable, EntityColumn entityColumn, KeySql keySql) {
        if (keySql.useGeneratedKeys()) {
            entityColumn.setIdentity(true);
            entityColumn.setGenerator("JDBC");
            entityTable.setKeyProperties(entityColumn.getProperty());
            entityTable.setKeyColumns(entityColumn.getColumn());
        } else if (keySql.dialect() == Identity.DEFAULT) {
            entityColumn.setIdentity(true);
            entityColumn.setOrder(Order.AFTER);
        } else if (keySql.dialect() != Identity.NULL) {
            entityColumn.setIdentity(true);
            entityColumn.setOrder(Order.AFTER);
            entityColumn.setGenerator(keySql.dialect().getIdentityRetrievalStatement());
        } else if (StringKit.isNotEmpty(keySql.sql())) {
            entityColumn.setIdentity(true);
            entityColumn.setOrder(keySql.order());
            entityColumn.setGenerator(keySql.sql());
        } else if (keySql.genSql() != GenSql.NULL.class) {
            entityColumn.setIdentity(true);
            entityColumn.setOrder(keySql.order());
            try {
                GenSql genSql = keySql.genSql().newInstance();
                entityColumn.setGenerator(genSql.genSql(entityTable, entityColumn));
            }
            catch (Exception e) {
                this.log.error("\u5b9e\u4f8b\u5316 GenSql \u5931\u8d25: " + e, (Throwable)e);
                throw new InstrumentException("\u5b9e\u4f8b\u5316 GenSql \u5931\u8d25: " + e, e);
            }
        } else if (keySql.genId() != GenId.NULL.class) {
            entityColumn.setIdentity(false);
            entityColumn.setGenIdClass(keySql.genId());
        } else {
            throw new InstrumentException(entityTable.getEntityClass().getCanonicalName() + " \u7c7b\u4e2d\u7684 @KeySql \u6ce8\u89e3\u914d\u7f6e\u65e0\u6548!");
        }
    }
}

