/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.mapper.provider.base;

import org.aoju.bus.mapper.builder.MapperBuilder;
import org.aoju.bus.mapper.builder.MapperTemplate;
import org.aoju.bus.mapper.builder.SqlBuilder;
import org.apache.ibatis.mapping.MappedStatement;

public class BaseSelectProvider
extends MapperTemplate {
    public BaseSelectProvider(Class<?> mapperClass, MapperBuilder mapperBuilder) {
        super(mapperClass, mapperBuilder);
    }

    public String selectOne(MappedStatement ms) {
        Class<?> entityClass = this.getEntityClass(ms);
        this.setResultType(ms, entityClass);
        StringBuilder sql = new StringBuilder();
        sql.append(SqlBuilder.selectAllColumns(entityClass));
        sql.append(SqlBuilder.fromTable(entityClass, this.tableName(entityClass)));
        sql.append(SqlBuilder.whereAllIfColumns(entityClass, this.isNotEmpty()));
        return sql.toString();
    }

    public String select(MappedStatement ms) {
        Class<?> entityClass = this.getEntityClass(ms);
        this.setResultType(ms, entityClass);
        StringBuilder sql = new StringBuilder();
        sql.append(SqlBuilder.selectAllColumns(entityClass));
        sql.append(SqlBuilder.fromTable(entityClass, this.tableName(entityClass)));
        sql.append(SqlBuilder.whereAllIfColumns(entityClass, this.isNotEmpty()));
        sql.append(SqlBuilder.orderByDefault(entityClass));
        return sql.toString();
    }

    public String selectByRowBounds(MappedStatement ms) {
        return this.select(ms);
    }

    public String selectByPrimaryKey(MappedStatement ms) {
        Class<?> entityClass = this.getEntityClass(ms);
        this.setResultType(ms, entityClass);
        StringBuilder sql = new StringBuilder();
        sql.append(SqlBuilder.selectAllColumns(entityClass));
        sql.append(SqlBuilder.fromTable(entityClass, this.tableName(entityClass)));
        sql.append(SqlBuilder.wherePKColumns(entityClass));
        return sql.toString();
    }

    public String selectCount(MappedStatement ms) {
        Class<?> entityClass = this.getEntityClass(ms);
        StringBuilder sql = new StringBuilder();
        sql.append(SqlBuilder.selectCount(entityClass));
        sql.append(SqlBuilder.fromTable(entityClass, this.tableName(entityClass)));
        sql.append(SqlBuilder.whereAllIfColumns(entityClass, this.isNotEmpty()));
        return sql.toString();
    }

    public String existsWithPrimaryKey(MappedStatement ms) {
        Class<?> entityClass = this.getEntityClass(ms);
        StringBuilder sql = new StringBuilder();
        sql.append(SqlBuilder.selectCountExists(entityClass));
        sql.append(SqlBuilder.fromTable(entityClass, this.tableName(entityClass)));
        sql.append(SqlBuilder.wherePKColumns(entityClass));
        return sql.toString();
    }

    public String selectAll(MappedStatement ms) {
        Class<?> entityClass = this.getEntityClass(ms);
        this.setResultType(ms, entityClass);
        StringBuilder sql = new StringBuilder();
        sql.append(SqlBuilder.selectAllColumns(entityClass));
        sql.append(SqlBuilder.fromTable(entityClass, this.tableName(entityClass)));
        sql.append("<where>");
        sql.append(SqlBuilder.whereLogicDelete(entityClass, false));
        sql.append("</where>");
        sql.append(SqlBuilder.orderByDefault(entityClass));
        return sql.toString();
    }
}

