/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.oauth.provider;

import com.alibaba.fastjson.JSONObject;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.aoju.bus.cache.metric.ExtendCache;
import org.aoju.bus.core.codec.Base64;
import org.aoju.bus.core.lang.Algorithm;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.core.lang.exception.AuthorizedException;
import org.aoju.bus.core.toolkit.RandomKit;
import org.aoju.bus.core.toolkit.UriKit;
import org.aoju.bus.http.Httpx;
import org.aoju.bus.oauth.Builder;
import org.aoju.bus.oauth.Context;
import org.aoju.bus.oauth.Registry;
import org.aoju.bus.oauth.magic.AccToken;
import org.aoju.bus.oauth.magic.Callback;
import org.aoju.bus.oauth.magic.Message;
import org.aoju.bus.oauth.magic.Property;
import org.aoju.bus.oauth.metric.OauthScope;
import org.aoju.bus.oauth.provider.AbstractProvider;

public class AmazonProvider
extends AbstractProvider {
    public AmazonProvider(Context context) {
        super(context, Registry.AMAZON);
    }

    public AmazonProvider(Context context, ExtendCache extendCache) {
        super(context, Registry.AMAZON, extendCache);
    }

    public static String generateCodeVerifier() {
        String randomStr = RandomKit.randomString(50);
        return Base64.encodeUrlSafe(randomStr);
    }

    public static String generateCodeChallenge(String codeChallengeMethod, String codeVerifier) {
        if ("S256".equalsIgnoreCase(codeChallengeMethod)) {
            return new String(Base64.encode(AmazonProvider.digest(codeVerifier), true, true), StandardCharsets.US_ASCII);
        }
        return codeVerifier;
    }

    public static byte[] digest(String text) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(Algorithm.SHA256.getValue());
            messageDigest.update(text.getBytes(StandardCharsets.UTF_8));
            return messageDigest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String authorize(String state) {
        Builder builder = Builder.fromUrl(this.source.authorize()).queryParam("client_id", this.context.getAppKey()).queryParam("scope", this.getScopes(" ", true, AmazonProvider.getScopes(false, OauthScope.Amazon.values()))).queryParam("redirect_uri", this.context.getRedirectUri()).queryParam("response_type", "code").queryParam("state", this.getRealState(state));
        if (this.context.isPkce()) {
            String cacheKey = this.source.getName().concat(":code_verifier:").concat(this.context.getAppKey());
            String codeVerifier = AmazonProvider.generateCodeVerifier();
            String codeChallengeMethod = "S256";
            String codeChallenge = AmazonProvider.generateCodeChallenge(codeChallengeMethod, codeVerifier);
            builder.queryParam("code_challenge", codeChallenge).queryParam("code_challenge_method", codeChallengeMethod);
            this.extendCache.cache(cacheKey, codeVerifier, TimeUnit.MINUTES.toMillis(10L));
        }
        return builder.build();
    }

    @Override
    protected AccToken getAccessToken(Callback callback) {
        HashMap<String, Object> form = new HashMap<String, Object>(8);
        form.put("grant_type", "authorization_code");
        form.put("code", callback.getCode());
        form.put("redirect_uri", this.context.getRedirectUri());
        form.put("client_id", this.context.getAppKey());
        form.put("client_secret", this.context.getAppSecret());
        if (this.context.isPkce()) {
            String cacheKey = this.source.getName().concat(":code_verifier:").concat(this.context.getAppKey());
            String codeVerifier = (String)this.extendCache.get(cacheKey);
            form.put("code_verifier", codeVerifier);
        }
        return this.getToken(form, this.source.accessToken());
    }

    @Override
    public Message refresh(AccToken authToken) {
        HashMap<String, Object> form = new HashMap<String, Object>(6);
        form.put("grant_type", "refresh_token");
        form.put("refresh_token", authToken.getRefreshToken());
        form.put("client_id", this.context.getAppKey());
        form.put("client_secret", this.context.getAppSecret());
        return Message.builder().errcode(Builder.ErrorCode.SUCCESS.getCode()).data(this.getToken(form, this.source.refresh())).build();
    }

    @Override
    protected Property getUserInfo(AccToken accToken) {
        String accessToken = accToken.getAccessToken();
        this.checkToken(accessToken);
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Host", "api.amazon.com");
        header.put("Authorization", "bearer " + accessToken);
        String userInfo = Httpx.get(this.source.userInfo(), new HashMap<String, Object>(0), header);
        JSONObject jsonObject = JSONObject.parseObject((String)userInfo);
        this.checkResponse(jsonObject);
        return Property.builder().rawJson(jsonObject).uuid(jsonObject.getString("user_id")).username(jsonObject.getString("name")).nickname(jsonObject.getString("name")).email(jsonObject.getString("email")).gender(Normal.Gender.UNKNOWN).source(this.source.toString()).token(accToken).build();
    }

    @Override
    protected String userInfoUrl(AccToken authToken) {
        return Builder.fromUrl(this.source.userInfo()).queryParam("user_id", authToken.getUserId()).queryParam("screen_name", authToken.getScreenName()).queryParam("include_entities", true).build();
    }

    private void checkToken(String accessToken) {
        String tokenInfo = Httpx.get("https://api.amazon.com/auth/o2/tokeninfo?access_token=" + UriKit.encode(accessToken));
        JSONObject jsonObject = JSONObject.parseObject((String)tokenInfo);
        if (!this.context.getAppKey().equals(jsonObject.getString("aud"))) {
            throw new AuthorizedException(Builder.ErrorCode.ILLEGAL_TOKEN.getMsg());
        }
    }

    private AccToken getToken(Map<String, Object> param, String url) {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Host", "api.amazon.com");
        header.put("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
        String response = Httpx.post(url, param, header);
        JSONObject jsonObject = JSONObject.parseObject((String)response);
        this.checkResponse(jsonObject);
        return AccToken.builder().accessToken(jsonObject.getString("access_token")).tokenType(jsonObject.getString("token_type")).expireIn(jsonObject.getIntValue("expires_in")).refreshToken(jsonObject.getString("refresh_token")).build();
    }

    private void checkResponse(JSONObject jsonObject) {
        if (jsonObject.containsKey((Object)"error")) {
            throw new AuthorizedException(jsonObject.getString("error_description").concat(" ") + jsonObject.getString("error_description"));
        }
    }
}

