/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.oauth.provider;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import org.aoju.bus.cache.metric.ExtendCache;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.http.Httpx;
import org.aoju.bus.http.Httpz;
import org.aoju.bus.http.magic.HttpResponse;
import org.aoju.bus.http.magic.PostBuilder;
import org.aoju.bus.oauth.Builder;
import org.aoju.bus.oauth.Context;
import org.aoju.bus.oauth.Registry;
import org.aoju.bus.oauth.magic.AccToken;
import org.aoju.bus.oauth.magic.Callback;
import org.aoju.bus.oauth.magic.Message;
import org.aoju.bus.oauth.magic.Property;
import org.aoju.bus.oauth.metric.OauthScope;
import org.aoju.bus.oauth.provider.AbstractProvider;

public class LineProvider
extends AbstractProvider {
    public LineProvider(Context config) {
        super(config, Registry.LINE);
    }

    public LineProvider(Context config, ExtendCache extendCache) {
        super(config, Registry.LINE, extendCache);
    }

    @Override
    protected AccToken getAccessToken(Callback callback) {
        JSONObject object = null;
        try {
            HttpResponse response = ((PostBuilder)((PostBuilder)((PostBuilder)((PostBuilder)((PostBuilder)((PostBuilder)Httpz.post().url(this.source.accessToken())).addParams("grant_type", "authorization_code")).addParams("code", callback.getCode())).addParams("redirect_uri", this.context.getRedirectUri())).addParams("client_id", this.context.getAppKey())).addParams("client_secret", this.context.getAppSecret())).build().execute();
            object = JSONObject.parseObject((String)response.body().toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return AccToken.builder().accessToken(object.getString("access_token")).refreshToken(object.getString("refresh_token")).expireIn(object.getIntValue("expires_in")).idToken(object.getString("id_token")).scope(object.getString("scope")).tokenType(object.getString("token_type")).build();
    }

    @Override
    protected Property getUserInfo(AccToken authToken) {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/x-www-form-urlencoded");
        header.put("Authorization", "Bearer ".concat(authToken.getAccessToken()));
        JSONObject object = JSONObject.parseObject((String)Httpx.post(this.source.revoke(), null, header));
        return Property.builder().rawJson(object).uuid(object.getString("userId")).username(object.getString("displayName")).nickname(object.getString("displayName")).avatar(object.getString("pictureUrl")).remark(object.getString("statusMessage")).gender(Normal.Gender.UNKNOWN).token(authToken).source(this.source.toString()).build();
    }

    @Override
    public Message revoke(AccToken authToken) {
        HashMap<String, Object> params = new HashMap<String, Object>(5);
        params.put("access_token", authToken.getAccessToken());
        params.put("client_id", this.context.getAppKey());
        params.put("client_secret", this.context.getAppSecret());
        JSONObject object = JSONObject.parseObject((String)Httpx.post(this.source.revoke(), params));
        Builder.ErrorCode status = object.getBooleanValue("revoked") ? Builder.ErrorCode.SUCCESS : Builder.ErrorCode.FAILURE;
        return Message.builder().errcode(status.getCode()).errmsg(status.getMsg()).build();
    }

    @Override
    public Message refresh(AccToken accToken) {
        return Message.builder().errcode(Builder.ErrorCode.SUCCESS.getCode()).data(this.getToken(this.refreshTokenUrl(accToken.getRefreshToken()))).build();
    }

    @Override
    public String userInfoUrl(AccToken accToken) {
        return Builder.fromUrl(this.source.userInfo()).queryParam("user", accToken.getUid()).build();
    }

    @Override
    public String authorize(String state) {
        return Builder.fromUrl(super.authorize(state)).queryParam("nonce", state).queryParam("scope", this.getScopes(" ", true, LineProvider.getScopes(true, OauthScope.Line.values()))).build();
    }

    private AccToken getToken(String accessTokenUrl) {
        JSONObject object = JSONObject.parseObject((String)Httpx.post(accessTokenUrl));
        return AccToken.builder().accessToken(object.getString("access_token")).refreshToken(object.getString("refresh_token")).expireIn(object.getIntValue("expires_in")).idToken(object.getString("id_token")).scope(object.getString("scope")).tokenType(object.getString("token_type")).build();
    }
}

