/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.magic.filter;

import com.sun.star.lang.XComponent;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.office.Context;
import org.aoju.bus.office.magic.filter.Filter;
import org.aoju.bus.office.magic.filter.FilterChain;

public abstract class AbstractFilter
implements FilterChain {
    protected List<Filter> filters;
    protected int pos;
    private boolean readOnly;

    public AbstractFilter() {
        this(false, new Filter[0]);
    }

    public AbstractFilter(Filter ... filters) {
        this(false, filters);
    }

    public AbstractFilter(boolean readOnly, Filter ... filters) {
        this.readOnly = readOnly;
        this.pos = 0;
        this.filters = Arrays.stream(Optional.ofNullable(filters).orElse(new Filter[0])).collect(Collectors.toList());
        if (readOnly) {
            this.filters = Collections.unmodifiableList(this.filters);
        }
    }

    @Override
    public void addFilter(Filter filter) {
        if (this.readOnly) {
            throw new UnsupportedOperationException();
        }
        this.filters.add(filter);
    }

    @Override
    public void doFilter(Context context, XComponent document) throws InstrumentException {
        if (this.pos < this.filters.size()) {
            Filter filter = this.filters.get(this.pos++);
            this.doFilter(filter, context, document);
        }
    }

    protected void doFilter(Filter filter, Context context, XComponent document) throws InstrumentException {
        try {
            filter.doFilter(context, document, this);
        }
        catch (InstrumentException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new InstrumentException("Could not apply filter " + filter.getClass().getName() + ".", ex);
        }
    }

    public void reset() {
        this.pos = 0;
    }
}

