/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.metric;

import java.io.File;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.office.Builder;
import org.aoju.bus.office.process.ProcessManager;

public class OfficeProcessBuilder {
    private File officeHome;
    private File workingDir;
    private ProcessManager processManager;
    private String[] runAsArgs;
    private File templateProfileDir;
    private boolean killExistingProcess = true;

    public OfficeProcessBuilder() {
        this(null, null, null);
    }

    public OfficeProcessBuilder(File officeHome, File workingDir, ProcessManager processManager) {
        this.officeHome = null == officeHome ? Builder.getDefaultOfficeHome() : officeHome;
        this.workingDir = null == workingDir ? new File(System.getProperty("java.io.tmpdir")) : workingDir;
        this.processManager = null == processManager ? Builder.findBestProcessManager() : processManager;
    }

    public File getOfficeHome() {
        return this.officeHome;
    }

    public void setOfficeHome(File officeHome) {
        this.officeHome = officeHome;
    }

    public ProcessManager getProcessManager() {
        return this.processManager;
    }

    public void setProcessManager(ProcessManager processManager) {
        this.processManager = processManager;
    }

    public String[] getRunAsArgs() {
        return ArrayKit.clone(this.runAsArgs);
    }

    public void setRunAsArgs(String ... runAsArgs) {
        this.runAsArgs = ArrayKit.clone(runAsArgs);
    }

    public File getWorkingDir() {
        return this.workingDir;
    }

    public void setWorkingDir(File workingDir) {
        this.workingDir = workingDir;
    }

    public File getTemplateProfileDir() {
        return this.templateProfileDir;
    }

    public void setTemplateProfileDir(File templateProfileDir) {
        this.templateProfileDir = templateProfileDir;
    }

    public boolean isKillExistingProcess() {
        return this.killExistingProcess;
    }

    public void setKillExistingProcess(boolean killExistingProcess) {
        this.killExistingProcess = killExistingProcess;
    }
}

