/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.metric;

import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XHierarchicalPropertySet;
import com.sun.star.beans.XHierarchicalPropertySetInfo;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Exception;
import com.sun.star.uno.XComponentContext;
import com.sun.star.util.XChangesBatch;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.office.builtin.MadeInOffice;
import org.aoju.bus.office.magic.Lo;
import org.aoju.bus.office.magic.UnoUrl;
import org.aoju.bus.office.metric.AbstractOfficeEntryManager;
import org.aoju.bus.office.metric.OfficeConnectEvent;
import org.aoju.bus.office.metric.OfficeConnectEventListener;
import org.aoju.bus.office.metric.OfficeProcessManager;
import org.aoju.bus.office.metric.OfficeProcessManagerEntryBuilder;

public class OfficeProcessEntryManager
extends AbstractOfficeEntryManager {
    private static final String PROPPATH_USE_OPENGL = "VCL/UseOpenGL";
    private final OfficeProcessManager officeProcessManager;
    private final AtomicInteger taskCount = new AtomicInteger(0);
    private final AtomicBoolean disconnectExpected = new AtomicBoolean(false);
    private final OfficeConnectEventListener connectionEventListener = new OfficeConnectEventListener(){

        @Override
        public void connected(OfficeConnectEvent event) {
            OfficeProcessEntryManager.this.taskCount.set(0);
            OfficeProcessEntryManager.this.taskExecutor.setAvailable(true);
        }

        @Override
        public void disconnected(OfficeConnectEvent event) {
            OfficeProcessEntryManager.this.taskExecutor.setAvailable(false);
            if (!OfficeProcessEntryManager.this.disconnectExpected.compareAndSet(true, false)) {
                Logger.warn("Connection lost unexpectedly; attempting restart", new Object[0]);
                if (null != OfficeProcessEntryManager.this.currentFuture) {
                    OfficeProcessEntryManager.this.currentFuture.cancel(true);
                }
                OfficeProcessEntryManager.this.officeProcessManager.restartDueToLostConnection();
            }
        }
    };

    public OfficeProcessEntryManager(UnoUrl unoUrl) {
        this(unoUrl, new OfficeProcessManagerEntryBuilder());
    }

    public OfficeProcessEntryManager(UnoUrl unoUrl, OfficeProcessManagerEntryBuilder config) {
        super(config);
        this.officeProcessManager = new OfficeProcessManager(unoUrl, config);
        this.officeProcessManager.getLocalOffice().addConnectionEventListener(this.connectionEventListener);
    }

    @Override
    public void doExecute(MadeInOffice task) throws InstrumentException {
        OfficeProcessManagerEntryBuilder entryConfig = (OfficeProcessManagerEntryBuilder)this.config;
        int count = this.taskCount.getAndIncrement();
        if (entryConfig.getMaxTasksPerProcess() > 0 && count == entryConfig.getMaxTasksPerProcess()) {
            Logger.info("Reached limit of {} maximum tasks per process; restarting...", entryConfig.getMaxTasksPerProcess());
            this.restart();
            this.taskCount.getAndIncrement();
        }
        task.execute(this.officeProcessManager.getLocalOffice());
    }

    @Override
    protected void handleExecuteTimeoutException(TimeoutException timeoutEx) {
        this.officeProcessManager.restartDueToTaskTimeout();
    }

    @Override
    public boolean isRunning() {
        return super.isRunning() && this.officeProcessManager.getLocalOffice().isConnected();
    }

    @Override
    public void doStart() throws InstrumentException {
        this.officeProcessManager.startAndWait();
        OfficeProcessManagerEntryBuilder entryConfig = (OfficeProcessManagerEntryBuilder)this.config;
        if (entryConfig.isDisableOpengl() && this.disableOpengl(this.officeProcessManager.getLocalOffice().getComponentContext())) {
            Logger.info("OpenGL has been disabled and a restart is required; restarting...", new Object[0]);
            this.restart();
        }
    }

    @Override
    public void doStop() throws InstrumentException {
        this.disconnectExpected.set(true);
        this.officeProcessManager.stopAndWait();
    }

    private void restart() throws InstrumentException {
        this.taskExecutor.setAvailable(false);
        this.disconnectExpected.set(true);
        this.officeProcessManager.restartAndWait();
    }

    private Object createConfigurationView(XMultiServiceFactory provider, String path) throws Exception {
        PropertyValue argument = new PropertyValue();
        argument.Name = "nodepath";
        argument.Value = path;
        Object[] arguments = new Object[]{argument};
        return provider.createInstanceWithArguments("com.sun.star.configuration.ConfigurationUpdateAccess", arguments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean disableOpengl(XComponentContext officeContext) throws InstrumentException {
        try {
            Object viewRoot = this.createConfigurationView(Lo.createInstanceMCF(officeContext, XMultiServiceFactory.class, "com.sun.star.configuration.ConfigurationProvider"), "/org.openoffice.Office.Common");
            try {
                XHierarchicalPropertySet properties = Lo.qi(XHierarchicalPropertySet.class, viewRoot);
                XHierarchicalPropertySetInfo propsInfo = properties.getHierarchicalPropertySetInfo();
                if (!propsInfo.hasPropertyByHierarchicalName(PROPPATH_USE_OPENGL)) return false;
                boolean useOpengl = (Boolean)properties.getHierarchicalPropertyValue(PROPPATH_USE_OPENGL);
                Logger.info("Use OpenGL is set to {}", useOpengl);
                if (!useOpengl) return false;
                properties.setHierarchicalPropertyValue(PROPPATH_USE_OPENGL, (Object)false);
                XChangesBatch updateControl = Lo.qi(XChangesBatch.class, viewRoot);
                updateControl.commitChanges();
                boolean bl = true;
                return bl;
            }
            finally {
                Lo.qi(XComponent.class, viewRoot).dispose();
            }
        }
        catch (Exception ex) {
            throw new InstrumentException("Unable to check if the Use OpenGL option is on.", ex);
        }
    }
}

