/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.provider;

import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.office.builtin.AbstractJob;
import org.aoju.bus.office.builtin.AbstractNorm;
import org.aoju.bus.office.builtin.OnlineMadeInOffice;
import org.aoju.bus.office.magic.family.FormatRegistry;
import org.aoju.bus.office.metric.OfficeManager;
import org.aoju.bus.office.provider.AbstractProvider;
import org.aoju.bus.office.provider.AbstractSourceProvider;
import org.aoju.bus.office.provider.AbstractTargetProvider;

public class OnlineOfficeProvider
extends AbstractProvider {
    private OnlineOfficeProvider(OfficeManager officeManager, FormatRegistry formatRegistry) {
        super(officeManager, formatRegistry);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static OnlineOfficeProvider make() {
        return OnlineOfficeProvider.builder().build();
    }

    public static OnlineOfficeProvider make(OfficeManager officeManager) {
        return ((Builder)OnlineOfficeProvider.builder().officeManager(officeManager)).build();
    }

    @Override
    protected AbstractNorm convert(AbstractSourceProvider source) {
        return new Online(source);
    }

    public static final class Builder
    extends AbstractProvider.AbstractConverterBuilder<Builder> {
        private Builder() {
        }

        @Override
        public OnlineOfficeProvider build() {
            return new OnlineOfficeProvider(this.officeManager, this.formatRegistry);
        }
    }

    private class Online
    extends AbstractNorm {
        private Online(AbstractSourceProvider source) {
            super(source, OnlineOfficeProvider.this.officeManager, OnlineOfficeProvider.this.formatRegistry);
        }

        @Override
        protected AbstractJob to(AbstractTargetProvider target) {
            return new OnlineJob(this.source, target);
        }
    }

    private class OnlineJob
    extends AbstractJob {
        private OnlineJob(AbstractSourceProvider source, AbstractTargetProvider target) {
            super(source, target);
        }

        @Override
        public void doExecute() throws InstrumentException {
            OnlineMadeInOffice task = new OnlineMadeInOffice(this.source, this.target);
            OnlineOfficeProvider.this.officeManager.execute(task);
        }
    }
}

