/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.support.excel;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.toolkit.BeanKit;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.core.toolkit.IterKit;
import org.aoju.bus.core.toolkit.MapKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.office.support.excel.CellKit;
import org.aoju.bus.office.support.excel.ExcelBase;
import org.aoju.bus.office.support.excel.ExcelKit;
import org.aoju.bus.office.support.excel.ExcelWriter;
import org.aoju.bus.office.support.excel.RowKit;
import org.aoju.bus.office.support.excel.WorksKit;
import org.aoju.bus.office.support.excel.cell.CellEditor;
import org.aoju.bus.office.support.excel.cell.CellHandler;
import org.aoju.bus.office.support.excel.reader.ListSheetReader;
import org.aoju.bus.office.support.excel.reader.SheetReader;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.extractor.ExcelExtractor;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.extractor.XSSFExcelExtractor;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelReader
extends ExcelBase<ExcelReader> {
    private boolean ignoreEmptyRow = true;
    private CellEditor cellEditor;

    public ExcelReader(Sheet sheet) {
        super(sheet);
    }

    public ExcelReader(String excelFilePath, int sheetIndex) {
        this(FileKit.file(excelFilePath), sheetIndex);
    }

    public ExcelReader(File bookFile, int sheetIndex) {
        this(WorksKit.createBook(bookFile, true), sheetIndex);
        this.destFile = bookFile;
    }

    public ExcelReader(File bookFile, String sheetName) {
        this(WorksKit.createBook(bookFile, true), sheetName);
        this.destFile = bookFile;
    }

    public ExcelReader(InputStream bookStream, int sheetIndex) {
        this(WorksKit.createBook(bookStream), sheetIndex);
    }

    public ExcelReader(InputStream bookStream, String sheetName) {
        this(WorksKit.createBook(bookStream), sheetName);
    }

    public ExcelReader(Workbook book, int sheetIndex) {
        this(book.getSheetAt(sheetIndex));
    }

    public ExcelReader(Workbook book, String sheetName) {
        this(book.getSheet(sheetName));
    }

    public boolean isIgnoreEmptyRow() {
        return this.ignoreEmptyRow;
    }

    public ExcelReader setIgnoreEmptyRow(boolean ignoreEmptyRow) {
        this.ignoreEmptyRow = ignoreEmptyRow;
        return this;
    }

    public ExcelReader setCellEditor(CellEditor cellEditor) {
        this.cellEditor = cellEditor;
        return this;
    }

    public List<List<Object>> read() {
        return this.read(0);
    }

    public List<List<Object>> read(int startRowIndex) {
        return this.read(startRowIndex, Integer.MAX_VALUE);
    }

    public List<List<Object>> read(int startRowIndex, int endRowIndex) {
        this.checkNotClosed();
        ArrayList<List<Object>> resultList = new ArrayList<List<Object>>();
        startRowIndex = Math.max(startRowIndex, this.sheet.getFirstRowNum());
        endRowIndex = Math.min(endRowIndex, this.sheet.getLastRowNum());
        boolean isFirstLine = true;
        for (int i = startRowIndex; i <= endRowIndex; ++i) {
            List<Object> rowList = this.readRow(i);
            if (!CollKit.isNotEmpty(rowList) && this.ignoreEmptyRow) continue;
            if (null == rowList) {
                rowList = new ArrayList<Object>(0);
            }
            if (isFirstLine) {
                isFirstLine = false;
                if (MapKit.isNotEmpty(this.headerAlias)) {
                    rowList = this.aliasHeader(rowList);
                }
            }
            resultList.add(rowList);
        }
        return resultList;
    }

    public <T> T read(SheetReader<T> sheetReader) {
        this.checkNotClosed();
        return Assert.notNull(sheetReader).read(this.sheet);
    }

    public void read(CellHandler cellHandler) {
        this.read(0, Integer.MAX_VALUE, cellHandler);
    }

    public List<List<Object>> read(int startRowIndex, int endRowIndex, boolean aliasFirstLine) {
        ListSheetReader reader = new ListSheetReader(startRowIndex, endRowIndex, aliasFirstLine);
        reader.setCellEditor(this.cellEditor);
        reader.setIgnoreEmptyRow(this.ignoreEmptyRow);
        reader.setHeaderAlias(this.headerAlias);
        return this.read(reader);
    }

    public void read(int startRowIndex, int endRowIndex, CellHandler cellHandler) {
        this.checkNotClosed();
        startRowIndex = Math.max(startRowIndex, this.sheet.getFirstRowNum());
        endRowIndex = Math.min(endRowIndex, this.sheet.getLastRowNum());
        for (int y = startRowIndex; y <= endRowIndex; ++y) {
            Row row = this.sheet.getRow(y);
            if (null == row) continue;
            short columnSize = row.getLastCellNum();
            for (short x = 0; x < columnSize; x = (short)(x + 1)) {
                Cell cell = row.getCell((int)x);
                cellHandler.handle(cell, CellKit.getCellValue(cell));
            }
        }
    }

    public List<Map<String, Object>> read(int headerRowIndex, int startRowIndex, int endRowIndex) {
        this.checkNotClosed();
        int firstRowNum = this.sheet.getFirstRowNum();
        int lastRowNum = this.sheet.getLastRowNum();
        if (headerRowIndex < firstRowNum) {
            throw new IndexOutOfBoundsException(StringKit.format((CharSequence)"Header row index {} is lower than first row index {}.", headerRowIndex, firstRowNum));
        }
        if (headerRowIndex > lastRowNum) {
            throw new IndexOutOfBoundsException(StringKit.format((CharSequence)"Header row index {} is greater than last row index {}.", headerRowIndex, firstRowNum));
        }
        startRowIndex = Math.max(startRowIndex, firstRowNum);
        endRowIndex = Math.min(endRowIndex, lastRowNum);
        List<Object> headerList = this.readRow(this.sheet.getRow(headerRowIndex));
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(endRowIndex - startRowIndex + 1);
        for (int i = startRowIndex; i <= endRowIndex; ++i) {
            List<Object> rowList;
            if (i == headerRowIndex || !CollKit.isNotEmpty(rowList = this.readRow(this.sheet.getRow(i))) && this.ignoreEmptyRow) continue;
            result.add(IterKit.toMap(this.aliasHeader(headerList), rowList, true));
        }
        return result;
    }

    public <T> List<T> read(int headerRowIndex, int startRowIndex, Class<T> beanType) {
        return this.read(headerRowIndex, startRowIndex, Integer.MAX_VALUE, beanType);
    }

    public <T> List<T> read(int headerRowIndex, int startRowIndex, int endRowIndex, Class<T> beanType) {
        this.checkNotClosed();
        List<Map<String, Object>> mapList = this.read(headerRowIndex, startRowIndex, endRowIndex);
        if (Map.class.isAssignableFrom(beanType)) {
            return mapList;
        }
        ArrayList<T> beanList = new ArrayList<T>(mapList.size());
        for (Map<String, Object> map : mapList) {
            beanList.add(BeanKit.mapToBean(map, beanType, false));
        }
        return beanList;
    }

    public List<Map<String, Object>> readAll() {
        return this.read(0, 1, Integer.MAX_VALUE);
    }

    public <T> List<T> readAll(Class<T> beanType) {
        return this.read(0, 1, Integer.MAX_VALUE, beanType);
    }

    public ExcelExtractor getExtractor(Workbook wb) {
        Object extractor = wb instanceof HSSFWorkbook ? new org.apache.poi.hssf.extractor.ExcelExtractor((HSSFWorkbook)wb) : new XSSFExcelExtractor((XSSFWorkbook)wb);
        return extractor;
    }

    public String readAsText(Workbook wb, boolean withSheetName) {
        ExcelExtractor extractor = this.getExtractor(wb);
        extractor.setIncludeSheetNames(withSheetName);
        return extractor.getText();
    }

    public List<Object> readRow(int rowIndex) {
        return this.readRow(this.sheet.getRow(rowIndex));
    }

    public Object readCellValue(int x, int y) {
        return CellKit.getCellValue(this.getCell(x, y), this.cellEditor);
    }

    public ExcelWriter getWriter() {
        return ExcelKit.getWriter(this.destFile, this.sheet.getSheetName());
    }

    private List<Object> readRow(Row row) {
        return RowKit.readRow(row, this.cellEditor);
    }

    private List<String> aliasHeader(List<Object> headerList) {
        if (CollKit.isEmpty(headerList)) {
            return new ArrayList<String>(0);
        }
        int size = headerList.size();
        ArrayList<String> result = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            result.add(this.aliasHeader(headerList.get(i), i));
        }
        return result;
    }

    private String aliasHeader(Object headerObj, int index) {
        if (null == headerObj) {
            return ExcelKit.indexToColName(index);
        }
        String header = headerObj.toString();
        return ObjectKit.defaultIfNull((String)this.headerAlias.get(header), header);
    }

    private void checkNotClosed() {
        Assert.isFalse(this.isClosed, "ExcelReader has been closed!", new Object[0]);
    }
}

