/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.support.excel;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class WorksKit {
    public static Workbook createBook(String excelFilePath) {
        return WorksKit.createBook(excelFilePath, false);
    }

    public static Workbook createBook(String excelFilePath, boolean readOnly) {
        return WorksKit.createBook(FileKit.file(excelFilePath), null, readOnly);
    }

    public static Workbook createBook(File excelFile) {
        return WorksKit.createBook(excelFile, false);
    }

    public static Workbook createBook(File excelFile, boolean readOnly) {
        return WorksKit.createBook(excelFile, null, readOnly);
    }

    public static Workbook createBookForWriter(File excelFile) {
        if (null == excelFile) {
            return WorksKit.createBook(true);
        }
        if (excelFile.exists()) {
            return WorksKit.createBook(FileKit.getInputStream(excelFile));
        }
        return WorksKit.createBook(StringKit.endWithIgnoreCase(excelFile.getName(), ".xlsx"));
    }

    public static Workbook createBook(File excelFile, String password) {
        return WorksKit.createBook(excelFile, password, false);
    }

    public static Workbook createBook(File excelFile, String password, boolean readOnly) {
        try {
            return WorkbookFactory.create((File)excelFile, (String)password, (boolean)readOnly);
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
    }

    public static Workbook createBook(InputStream in) {
        return WorksKit.createBook(in, null);
    }

    public static Workbook createBook(InputStream in, String password) {
        try {
            Workbook workbook = WorkbookFactory.create((InputStream)IoKit.toMarkSupportStream(in), (String)password);
            return workbook;
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
        finally {
            IoKit.close(in);
        }
    }

    public static Workbook createBook(boolean isXlsx) {
        Object workbook = isXlsx ? new XSSFWorkbook() : new HSSFWorkbook();
        return workbook;
    }

    public static SXSSFWorkbook createSXSSFBook(String excelFilePath) {
        return WorksKit.createSXSSFBook(excelFilePath, false);
    }

    public static SXSSFWorkbook createSXSSFBook(String excelFilePath, boolean readOnly) {
        return WorksKit.createSXSSFBook(FileKit.file(excelFilePath), null, readOnly);
    }

    public static SXSSFWorkbook createSXSSFBook(File excelFile) {
        return WorksKit.createSXSSFBook(excelFile, false);
    }

    public static SXSSFWorkbook createSXSSFBook(File excelFile, boolean readOnly) {
        return WorksKit.createSXSSFBook(excelFile, null, readOnly);
    }

    public static SXSSFWorkbook createSXSSFBook(File excelFile, String password) {
        return WorksKit.createSXSSFBook(excelFile, password, false);
    }

    public static SXSSFWorkbook createSXSSFBook(File excelFile, String password, boolean readOnly) {
        return WorksKit.toSXSSFBook(WorksKit.createBook(excelFile, password, readOnly));
    }

    public static SXSSFWorkbook createSXSSFBook(InputStream in) {
        return WorksKit.createSXSSFBook(in, null);
    }

    public static SXSSFWorkbook createSXSSFBook(InputStream in, String password) {
        return WorksKit.toSXSSFBook(WorksKit.createBook(in, password));
    }

    public static SXSSFWorkbook createSXSSFBook() {
        return new SXSSFWorkbook();
    }

    public static SXSSFWorkbook createSXSSFBook(int rowAccessWindowSize) {
        return new SXSSFWorkbook(rowAccessWindowSize);
    }

    public static SXSSFWorkbook createSXSSFBook(int rowAccessWindowSize, boolean compressTmpFiles, boolean useSharedStringsTable) {
        return new SXSSFWorkbook(null, rowAccessWindowSize, compressTmpFiles, useSharedStringsTable);
    }

    public static void writeBook(Workbook book, OutputStream out) throws InstrumentException {
        try {
            book.write(out);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static Sheet getOrCreateSheet(Workbook book, String sheetName) {
        if (null == book) {
            return null;
        }
        Sheet sheet = book.getSheet(sheetName = StringKit.isBlank(sheetName) ? "sheet1" : sheetName);
        if (null == sheet) {
            sheet = book.createSheet(sheetName);
        }
        return sheet;
    }

    public static Sheet getOrCreateSheet(Workbook book, int sheetIndex) {
        Sheet sheet = null;
        try {
            sheet = book.getSheetAt(sheetIndex);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (null == sheet) {
            sheet = book.createSheet();
        }
        return sheet;
    }

    public static boolean isEmpty(Sheet sheet) {
        return null == sheet || sheet.getLastRowNum() == 0 && sheet.getPhysicalNumberOfRows() == 0;
    }

    private static SXSSFWorkbook toSXSSFBook(Workbook book) {
        if (book instanceof SXSSFWorkbook) {
            return (SXSSFWorkbook)book;
        }
        if (book instanceof XSSFWorkbook) {
            return new SXSSFWorkbook((XSSFWorkbook)book);
        }
        throw new InstrumentException("The input is not a [xlsx] format.");
    }
}

