/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.support.excel.cell.values;

import java.util.Date;
import org.aoju.bus.core.toolkit.DateKit;
import org.aoju.bus.office.Builder;
import org.aoju.bus.office.support.excel.cell.CellValue;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.util.NumberToTextConverter;

public class NumericCellValue
implements CellValue<Object> {
    private final Cell cell;

    public NumericCellValue(Cell cell) {
        this.cell = cell;
    }

    @Override
    public Object getValue() {
        double value = this.cell.getNumericCellValue();
        CellStyle style = this.cell.getCellStyle();
        if (null != style) {
            long longPart;
            if (Builder.isDateFormat(this.cell)) {
                Date dateCellValue = this.cell.getDateCellValue();
                if ("1899".equals(DateKit.format(dateCellValue, "yyyy"))) {
                    return DateKit.format(dateCellValue, style.getDataFormatString());
                }
                return DateKit.date(dateCellValue);
            }
            String format = style.getDataFormatString();
            if (null != format && format.indexOf(46) < 0 && (double)(longPart = (long)value) == value) {
                return longPart;
            }
        }
        return Double.parseDouble(NumberToTextConverter.toText((double)value));
    }
}

