/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.tracer.binding.quartz;

import org.aoju.bus.tracer.Backend;
import org.aoju.bus.tracer.Tracer;
import org.aoju.bus.tracer.config.TraceFilterConfig;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.Trigger;

public class TraceContextInjector {
    private final Backend backend;
    private final String profile;

    public TraceContextInjector() {
        this(Tracer.getBackend(), "default");
    }

    public TraceContextInjector(String profile) {
        this(Tracer.getBackend(), profile);
    }

    TraceContextInjector(Backend backend, String profile) {
        this.backend = backend;
        this.profile = profile;
    }

    public void injectContext(Trigger trigger) {
        this.injectContext(trigger.getJobDataMap());
    }

    public void injectContext(JobDetail jobDetail) {
        this.injectContext(jobDetail.getJobDataMap());
    }

    public void injectContext(JobDataMap jobDataMap) {
        TraceFilterConfig configuration = this.backend.getConfiguration(this.profile);
        if (!this.backend.isEmpty() && configuration.shouldProcessContext(TraceFilterConfig.Channel.AsyncDispatch)) {
            jobDataMap.put("TPIC", this.backend.getConfiguration(this.profile).filterDeniedParams(this.backend.copyToMap(), TraceFilterConfig.Channel.AsyncDispatch));
        }
    }
}

