/*********************************************************************************
 *                                                                               *
 * The MIT License (MIT)                                                         *
 *                                                                               *
 * Copyright (c) 2015-2022 aoju.org and other contributors.                      *
 *                                                                               *
 * Permission is hereby granted, free of charge, to any person obtaining a copy  *
 * of this software and associated documentation files (the "Software"), to deal *
 * in the Software without restriction, including without limitation the rights  *
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell     *
 * copies of the Software, and to permit persons to whom the Software is         *
 * furnished to do so, subject to the following conditions:                      *
 *                                                                               *
 * The above copyright notice and this permission notice shall be included in    *
 * all copies or substantial portions of the Software.                           *
 *                                                                               *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR    *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,      *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE   *
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER        *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, *
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN     *
 * THE SOFTWARE.                                                                 *
 *                                                                               *
 ********************************************************************************/
package org.aoju.bus.base.entity;

import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Transient;

/**
 * 授权公用类
 *
 * @author Kimi Liu
 * @since Java 17+
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class OAuth2 extends Entity {

    private static final long serialVersionUID = 1L;

    /**
     * 当前用户标识
     */
    @Transient
    protected String x_user_id;

    /**
     * 当前用户名称
     */
    @Transient
    protected String x_user_name;

    /**
     * 当前用户角色
     */
    @Transient
    private String x_role_id;

    /**
     * 当前用户职称
     */
    @Transient
    private String x_duty_id;

    /**
     * 当前用户组织
     */
    @Transient
    private String x_org_id;

    /**
     * 当前用户设备
     */
    @Transient
    private String x_device_id;

    /**
     * 扩展参数信息
     */
    @Transient
    private String x_extension;

}
