/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.aoju.bus.core.annotation.Ignore;
import org.aoju.bus.core.annotation.Values;
import org.aoju.bus.core.convert.Convert;
import org.aoju.bus.core.exception.InstrumentException;
import org.aoju.bus.core.io.resource.PropertySource;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.toolkit.ClassKit;
import org.aoju.bus.core.toolkit.StringKit;

public class Binder {
    public static final String DEFAULT_PLACEHOLDER_PREFIX = "${";
    public static final String DEFAULT_PLACEHOLDER_SUFFIX = "}";
    public static final String DEFAULT_VALUE_SEPARATOR = ":";
    public static final Binder DEFAULT_HELPER;
    private static final Map<String, String> SIMPLE_PREFIXES;
    private final String placeholderPrefix;
    private final String placeholderSuffix;
    private final String simplePrefix;
    private final String valueSeparator;
    private final boolean ignoreUnresolvablePlaceholders;
    private PropertySource source;

    public Binder(String placeholderPrefix, String placeholderSuffix) {
        this(placeholderPrefix, placeholderSuffix, null, true);
    }

    public Binder(String placeholderPrefix, String placeholderSuffix, String valueSeparator, boolean ignoreUnresolvablePlaceholders) {
        Assert.notNull(placeholderPrefix, "'placeholderPrefix' must not be null", new Object[0]);
        Assert.notNull(placeholderSuffix, "'placeholderSuffix' must not be null", new Object[0]);
        this.placeholderPrefix = placeholderPrefix;
        this.placeholderSuffix = placeholderSuffix;
        String simplePrefixForSuffix = SIMPLE_PREFIXES.get(this.placeholderSuffix);
        this.simplePrefix = null != simplePrefixForSuffix && this.placeholderPrefix.endsWith(simplePrefixForSuffix) ? simplePrefixForSuffix : this.placeholderPrefix;
        this.valueSeparator = valueSeparator;
        this.ignoreUnresolvablePlaceholders = ignoreUnresolvablePlaceholders;
    }

    private static boolean substringMatch(CharSequence text, int index, CharSequence substring) {
        if (index + substring.length() > text.length()) {
            return false;
        }
        for (int i = 0; i < substring.length(); ++i) {
            if (text.charAt(index + i) == substring.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public <T> T bind(Class<T> clazz) {
        return (T)this.bind((T)clazz, ".");
    }

    public <T> T bind(Class<T> clazz, String prefix) {
        boolean b;
        T obj;
        try {
            obj = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
        Class<?> actualClass = ClassKit.getCglibActualClass(clazz);
        boolean bl = b = (null == prefix || ".".equals(prefix)) && actualClass.isAnnotationPresent(Values.class);
        if (b) {
            prefix = actualClass.getAnnotation(Values.class).value();
        }
        return clazz.cast(this.bind(obj, prefix));
    }

    public <T> T bind(T obj, String prefix) {
        if (!StringKit.hasText(prefix) || ".".equals(prefix)) {
            prefix = null;
        }
        for (Field field : ClassKit.getDeclaredFields(obj.getClass())) {
            this.bindField(obj, field, prefix);
        }
        return obj;
    }

    private void bindField(Object obj, Field field, String prefix) {
        try {
            if (field.isAnnotationPresent(Ignore.class)) {
                return;
            }
            Object key = field.getName();
            boolean wrap = false;
            if (field.isAnnotationPresent(Values.class)) {
                key = field.getAnnotation(Values.class).value();
                wrap = true;
            } else if (null != prefix) {
                key = prefix + "." + (String)key;
            }
            Object value = this.getProperty((String)key, field.getType(), wrap);
            if (null != value) {
                ClassKit.writeField(field, obj, value);
                return;
            }
            if (null != field.getType().getClassLoader() && this.source.containPrefix((String)key + ".")) {
                value = ClassKit.readField(field, obj);
                if (null == value) {
                    value = this.bind((Object)field.getType(), (String)key);
                    ClassKit.writeField(field, obj, value);
                } else {
                    this.bind(value, (String)key);
                }
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private Object getProperty(String key, Class<?> type, boolean wrap) {
        String value = wrap ? this.source.getPlaceholderProperty(key) : this.source.getProperty(key);
        if (null == value || value.getClass() == type) {
            return value;
        }
        return Convert.convert(type, (Object)value);
    }

    public String replacePlaceholders(String value, Properties properties) {
        Assert.notNull(properties, "'properties' must not be null", new Object[0]);
        Assert.notNull(value, "'value' must not be null", new Object[0]);
        return this.parseStringValue(value, properties, new HashSet<String>());
    }

    protected String parseStringValue(String value, Properties properties, Set<String> visitedPlaceholders) {
        StringBuilder result = new StringBuilder(value);
        int startIndex = value.indexOf(this.placeholderPrefix);
        while (startIndex != -1) {
            int endIndex = this.findPlaceholderEndIndex(result, startIndex);
            if (endIndex != -1) {
                String placeholder = result.substring(startIndex + this.placeholderPrefix.length(), endIndex);
                String originalPlaceholder = placeholder;
                if (!visitedPlaceholders.add(originalPlaceholder)) {
                    throw new IllegalArgumentException("Circular placeholder reference '" + originalPlaceholder + "' in property definitions");
                }
                placeholder = this.parseStringValue(placeholder, properties, visitedPlaceholders);
                String propVal = properties.getProperty(placeholder);
                if (null != (propVal = this.getCommonVal(properties, placeholder, propVal))) {
                    propVal = this.parseStringValue(propVal, properties, visitedPlaceholders);
                    result.replace(startIndex, endIndex + this.placeholderSuffix.length(), propVal);
                    startIndex = result.indexOf(this.placeholderPrefix, startIndex + propVal.length());
                } else if (this.ignoreUnresolvablePlaceholders) {
                    startIndex = result.indexOf(this.placeholderPrefix, endIndex + this.placeholderSuffix.length());
                } else {
                    throw new IllegalArgumentException(String.format("Could not resolve placeholder '%s' in value '%s'", placeholder, value));
                }
                visitedPlaceholders.remove(originalPlaceholder);
                continue;
            }
            startIndex = -1;
        }
        return result.toString();
    }

    private String getCommonVal(Properties properties, String placeholder, String propVal) {
        int separatorIndex;
        if (null == propVal && null != this.valueSeparator && (separatorIndex = placeholder.indexOf(this.valueSeparator)) != -1) {
            String actualPlaceholder = placeholder.substring(0, separatorIndex);
            String defaultValue = placeholder.substring(separatorIndex + this.valueSeparator.length());
            propVal = properties.getProperty(actualPlaceholder);
            if (null == propVal) {
                propVal = defaultValue;
            }
        }
        return propVal;
    }

    private int findPlaceholderEndIndex(CharSequence buf, int startIndex) {
        int index = startIndex + this.placeholderPrefix.length();
        int withinNestedPlaceholder = 0;
        while (index < buf.length()) {
            if (Binder.substringMatch(buf, index, this.placeholderSuffix)) {
                if (withinNestedPlaceholder > 0) {
                    --withinNestedPlaceholder;
                    index += this.placeholderSuffix.length();
                    continue;
                }
                return index;
            }
            if (Binder.substringMatch(buf, index, this.simplePrefix)) {
                ++withinNestedPlaceholder;
                index += this.simplePrefix.length();
                continue;
            }
            ++index;
        }
        return -1;
    }

    public Binder(String placeholderPrefix, String placeholderSuffix, String simplePrefix, String valueSeparator, boolean ignoreUnresolvablePlaceholders) {
        this.placeholderPrefix = placeholderPrefix;
        this.placeholderSuffix = placeholderSuffix;
        this.simplePrefix = simplePrefix;
        this.valueSeparator = valueSeparator;
        this.ignoreUnresolvablePlaceholders = ignoreUnresolvablePlaceholders;
    }

    static {
        SIMPLE_PREFIXES = new HashMap<String, String>(4);
        SIMPLE_PREFIXES.put(DEFAULT_PLACEHOLDER_SUFFIX, "{");
        SIMPLE_PREFIXES.put("]", "[");
        SIMPLE_PREFIXES.put(")", "(");
        DEFAULT_HELPER = new Binder(DEFAULT_PLACEHOLDER_PREFIX, DEFAULT_PLACEHOLDER_SUFFIX, DEFAULT_VALUE_SEPARATOR, true);
    }
}

