/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.compiler;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.StandardLocation;
import org.aoju.bus.core.compiler.DiagnosticCollectors;
import org.aoju.bus.core.compiler.JavaClassFileManager;
import org.aoju.bus.core.compiler.JavaFileObject;
import org.aoju.bus.core.compiler.JavaSourceFileObject;
import org.aoju.bus.core.exception.InstrumentException;
import org.aoju.bus.core.io.resource.FileResource;
import org.aoju.bus.core.io.resource.Resource;
import org.aoju.bus.core.io.resource.StringResource;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.ClassKit;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.core.toolkit.MapKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.UriKit;

public class JavaSourceCompiler {
    private final List<Resource> sourceList = new ArrayList<Resource>();
    private final List<File> libraryFileList = new ArrayList<File>();
    private final ClassLoader parentClassLoader;

    private JavaSourceCompiler(ClassLoader parent) {
        this.parentClassLoader = ObjectKit.defaultIfNull(parent, ClassKit::getClassLoader);
    }

    public static JavaSourceCompiler create(ClassLoader parent) {
        return new JavaSourceCompiler(parent);
    }

    public JavaSourceCompiler addSource(Resource ... resources) {
        if (ArrayKit.isNotEmpty(resources)) {
            this.sourceList.addAll(Arrays.asList(resources));
        }
        return this;
    }

    public JavaSourceCompiler addSource(File ... files) {
        if (ArrayKit.isNotEmpty(files)) {
            for (File file : files) {
                this.sourceList.add(new FileResource(file));
            }
        }
        return this;
    }

    public JavaSourceCompiler addSource(Map<String, String> sourceCodeMap) {
        if (MapKit.isNotEmpty(sourceCodeMap)) {
            sourceCodeMap.forEach(this::addSource);
        }
        return this;
    }

    public JavaSourceCompiler addSource(String className, String sourceCode) {
        if (className != null && sourceCode != null) {
            this.sourceList.add(new StringResource(sourceCode, className));
        }
        return this;
    }

    public JavaSourceCompiler addLibrary(File ... files) {
        if (ArrayKit.isNotEmpty(files)) {
            this.libraryFileList.addAll(Arrays.asList(files));
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassLoader compile() {
        List<File> classPath = this.getClassPath();
        URL[] urLs = UriKit.getURL(classPath.toArray(new File[0]));
        URLClassLoader ucl = URLClassLoader.newInstance(urLs, this.parentClassLoader);
        if (this.sourceList.isEmpty()) {
            return ucl;
        }
        JavaClassFileManager javaFileManager = new JavaClassFileManager(ucl, ClassKit.getFileManager());
        ArrayList<String> options = new ArrayList<String>();
        if (!classPath.isEmpty()) {
            List<String> cp = CollKit.map(classPath, File::getAbsolutePath, true);
            options.add("-cp");
            options.add(CollKit.join(cp, (CharSequence)(FileKit.isWindows() ? ";" : ":")));
        }
        DiagnosticCollector diagnosticCollector = new DiagnosticCollector();
        List<javax.tools.JavaFileObject> javaFileObjectList = this.getJavaFileObject();
        JavaCompiler.CompilationTask task = ClassKit.getTask(javaFileManager, diagnosticCollector, options, javaFileObjectList);
        try {
            if (task.call().booleanValue()) {
                ClassLoader classLoader = javaFileManager.getClassLoader(StandardLocation.CLASS_OUTPUT);
                return classLoader;
            }
        }
        finally {
            IoKit.close(javaFileManager);
        }
        throw new InstrumentException(DiagnosticCollectors.getMessages(diagnosticCollector));
    }

    private List<File> getClassPath() {
        ArrayList<File> classPathFileList = new ArrayList<File>();
        for (File file : this.libraryFileList) {
            List<File> jarOrZipFile = FileKit.loopFiles(file, subFile -> JavaFileObject.isJarOrZipFile(subFile.getName()));
            classPathFileList.addAll(jarOrZipFile);
            if (!file.isDirectory()) continue;
            classPathFileList.add(file);
        }
        return classPathFileList;
    }

    private List<javax.tools.JavaFileObject> getJavaFileObject() {
        ArrayList<javax.tools.JavaFileObject> list = new ArrayList<javax.tools.JavaFileObject>();
        for (Resource resource : this.sourceList) {
            if (resource instanceof FileResource) {
                File file = ((FileResource)resource).getFile();
                FileKit.walkFiles(file, subFile -> list.addAll(JavaFileObject.getJavaFileObjects(file)));
                continue;
            }
            list.add(new JavaSourceFileObject(resource.getName(), resource.getStream()));
        }
        return list;
    }

    private Collection<javax.tools.JavaFileObject> getJavaFileObjectByMap(Map<String, String> sourceCodeMap) {
        if (MapKit.isNotEmpty(sourceCodeMap)) {
            return sourceCodeMap.entrySet().stream().map(entry -> new JavaSourceFileObject((String)entry.getKey(), (String)entry.getValue(), Charset.UTF_8)).collect(Collectors.toList());
        }
        return Collections.emptySet();
    }

    private javax.tools.JavaFileObject getJavaFileObjectByJavaFile(File file) {
        return new JavaSourceFileObject(file.toURI());
    }
}

