/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.compress;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterOutputStream;
import org.aoju.bus.core.exception.InstrumentException;
import org.aoju.bus.core.toolkit.IoKit;

public class Deflate
implements Closeable {
    private final InputStream source;
    private final boolean nowrap;
    private OutputStream target;

    public Deflate(InputStream source, OutputStream target, boolean nowrap) {
        this.source = source;
        this.target = target;
        this.nowrap = nowrap;
    }

    public static Deflate of(InputStream source, OutputStream target, boolean nowrap) {
        return new Deflate(source, target, nowrap);
    }

    @Override
    public void close() {
        IoKit.close(this.target);
        IoKit.close(this.source);
    }

    public OutputStream getTarget() {
        return this.target;
    }

    public Deflate deflater(int level) {
        this.target = this.target instanceof DeflaterOutputStream ? (DeflaterOutputStream)this.target : new DeflaterOutputStream(this.target, new Deflater(level, this.nowrap));
        IoKit.copy(this.source, this.target);
        try {
            ((DeflaterOutputStream)this.target).finish();
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
        return this;
    }

    public Deflate inflater() {
        this.target = this.target instanceof InflaterOutputStream ? (InflaterOutputStream)this.target : new InflaterOutputStream(this.target, new Inflater(this.nowrap));
        IoKit.copy(this.source, this.target);
        try {
            ((InflaterOutputStream)this.target).finish();
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
        return this;
    }
}

