/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.io;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.aoju.bus.core.io.EventFactory;

public final class RingBuffer<T> {
    private static final byte READABLE = 1;
    private static final byte READING = 2;
    private static final byte WRITEABLE = 4;
    private static final byte WRITING = 8;
    private final Node<T>[] items;
    private final ReentrantLock lock;
    private final Condition notEmpty;
    private final Condition notFull;
    private final EventFactory<T> eventFactory;
    private int takeIndex;
    private int putIndex;
    private volatile boolean needFullSingle = false;
    private volatile boolean needEmptySingle = false;

    public RingBuffer(int capacity, EventFactory<T> factory) {
        if (capacity <= 0) {
            throw new IllegalArgumentException();
        }
        this.items = new Node[capacity];
        this.lock = new ReentrantLock(false);
        this.notEmpty = this.lock.newCondition();
        this.notFull = this.lock.newCondition();
        this.eventFactory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int nextWriteIndex() throws InterruptedException {
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            this.notFullSignal();
            Node<T>[] items = this.items;
            Node<T> node = items[this.putIndex];
            if (null == node) {
                node = new Node<T>(this.eventFactory.newInstance());
                node.status = (byte)4;
                items[this.putIndex] = node;
            }
            while (node.status != 4) {
                this.notFull.await();
                this.notFullSignal();
                node = items[this.putIndex];
            }
            node.status = (byte)8;
            int index = this.putIndex++;
            if (this.putIndex == items.length) {
                this.putIndex = 0;
            }
            int n = index;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int tryNextWriteIndex() throws InterruptedException {
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            this.notFullSignal();
            Node<T>[] items = this.items;
            Node<T> node = items[this.putIndex];
            if (null == node) {
                node = new Node<T>(this.eventFactory.newInstance());
                node.status = (byte)4;
                items[this.putIndex] = node;
            }
            if (node.status != 4) {
                int n = -1;
                return n;
            }
            node.status = (byte)8;
            int index = this.putIndex++;
            if (this.putIndex == items.length) {
                this.putIndex = 0;
            }
            int n = index;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishWriteIndex(int sequence) {
        Node<T> node = this.items[sequence];
        if (node.status != 8) {
            throw new RuntimeException("invalid status");
        }
        node.status = 1;
        ReentrantLock lock = this.lock;
        this.needEmptySingle = true;
        if (lock.tryLock()) {
            try {
                this.notFullSignal();
            }
            finally {
                lock.unlock();
            }
        }
    }

    public T get(int sequence) {
        return (T)this.items[sequence].entity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int tryNextReadIndex() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            this.notFullSignal();
            Node<T>[] items = this.items;
            Node<T> x = items[this.takeIndex];
            if (null == x || x.status != 1) {
                int n = -1;
                return n;
            }
            x.status = (byte)2;
            int index = this.takeIndex++;
            if (this.takeIndex == items.length) {
                this.takeIndex = 0;
            }
            int n = index;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int nextReadIndex() throws InterruptedException {
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            this.notFullSignal();
            Node<T>[] items = this.items;
            Node<T> x = items[this.takeIndex];
            while (null == x || x.status != 1) {
                this.notEmpty.await();
                this.notFullSignal();
                x = items[this.takeIndex];
            }
            x.status = (byte)2;
            int index = this.takeIndex++;
            if (this.takeIndex == items.length) {
                this.takeIndex = 0;
            }
            int n = index;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    private void notFullSignal() {
        if (this.needFullSingle) {
            this.notFull.signal();
            this.needFullSingle = false;
        }
        if (this.needEmptySingle) {
            this.notEmpty.signal();
            this.needEmptySingle = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishReadIndex(int sequence) {
        Node<T> node = this.items[sequence];
        if (node.status != 2) {
            throw new RuntimeException("invalid status");
        }
        this.eventFactory.restEntity(node.entity);
        node.status = (byte)4;
        ReentrantLock lock = this.lock;
        this.needFullSingle = true;
        if (lock.tryLock()) {
            try {
                this.notFullSignal();
            }
            finally {
                lock.unlock();
            }
        }
    }

    class Node<T1> {
        byte status;
        T1 entity;

        Node(T1 entity) {
            this.entity = entity;
        }
    }
}

