/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.io.resource;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import javax.tools.FileObject;
import org.aoju.bus.core.exception.InstrumentException;
import org.aoju.bus.core.io.resource.Resource;
import org.aoju.bus.core.toolkit.IoKit;

public class FileObjectResource
implements Resource {
    private final FileObject fileObject;

    public FileObjectResource(FileObject fileObject) {
        this.fileObject = fileObject;
    }

    public FileObject getFileObject() {
        return this.fileObject;
    }

    @Override
    public String getName() {
        return this.fileObject.getName();
    }

    @Override
    public URL getUrl() {
        try {
            return this.fileObject.toUri().toURL();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @Override
    public InputStream getStream() {
        try {
            return this.fileObject.openInputStream();
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    @Override
    public BufferedReader getReader(Charset charset) {
        try {
            return IoKit.getReader(this.fileObject.openReader(false));
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }
}

