/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.io.resource;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import org.aoju.bus.core.exception.InstrumentException;
import org.aoju.bus.core.io.resource.Resource;
import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.UriKit;

public class UriResource
implements Resource {
    protected URL url;
    protected String name;
    private long lastModified = 0L;

    public UriResource() {
    }

    public UriResource(URL url) {
        this(url, null);
    }

    public UriResource(URI uri) {
        this(UriKit.url(uri), null);
    }

    public UriResource(URL url, String name) {
        this.url = url;
        this.name = ObjectKit.defaultIfNull(name, () -> null != url ? FileKit.getName(url.getPath()) : null);
        if (null != url && UriKit.isFileURL(url)) {
            this.lastModified = FileKit.file(url).lastModified();
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    @Override
    public InputStream getStream() {
        if (null == this.url) {
            throw new InstrumentException("Resource URL is null!");
        }
        return UriKit.getStream(this.url);
    }

    @Override
    public boolean isModified() {
        return 0L != this.lastModified && this.lastModified != this.getFile().lastModified();
    }

    public File getFile() {
        return FileKit.file(this.url);
    }

    public String toString() {
        return null == this.url ? "null" : this.url.toString();
    }
}

