/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.io.streams;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.aoju.bus.core.exception.InstrumentException;
import org.aoju.bus.core.io.streams.StringOutputStream;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.toolkit.IoKit;

public class StreamBuffer
extends InputStream {
    private final OutputStreamBuffer buffer = new OutputStreamBuffer();
    private int index = 0;
    private int cursor = 0;

    public OutputStream getBuffer() {
        return this.buffer;
    }

    public void write(int b) throws IOException {
        this.buffer.write(b);
    }

    @Override
    public int read() throws IOException {
        if (this.cursor > this.buffer.width) {
            ++this.index;
            this.cursor = 0;
        }
        if (this.index > this.buffer.index) {
            return -1;
        }
        if (this.index < this.buffer.bytes.size()) {
            byte[] cs = this.buffer.bytes.get(this.index);
            if (this.cursor < this.buffer.cursor) {
                return cs[this.cursor++];
            }
        }
        return -1;
    }

    @Override
    public int available() {
        return this.buffer.size();
    }

    @Override
    public synchronized void reset() {
        this.index = 0;
        this.cursor = 0;
    }

    public String toString() {
        try {
            return this.toString(Charset.DEFAULT_CHARSET);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public String toString(String charset) throws IOException {
        byte c;
        this.index = 0;
        this.cursor = 0;
        StringBuilder sb = new StringBuilder();
        StringOutputStream sos = new StringOutputStream(sb, charset);
        while ((c = (byte)this.read()) != -1) {
            sos.write(c);
        }
        sos.flush();
        IoKit.close(sos);
        return sb.toString();
    }

    private static class OutputStreamBuffer
    extends OutputStream {
        private final List<byte[]> bytes = new ArrayList<byte[]>();
        private final int width = 1024;
        private int index = 0;
        private int cursor = 0;

        private OutputStreamBuffer() {
        }

        @Override
        public void write(int b) throws IOException {
            byte[] row;
            if (this.cursor >= 1024) {
                ++this.index;
            }
            byte[] byArray = row = this.bytes.size() > this.index ? this.bytes.get(this.index) : null;
            if (null == row) {
                row = new byte[1024];
                this.bytes.add(row);
                this.cursor = 0;
            }
            row[this.cursor++] = (byte)b;
        }

        private int size() {
            return this.index > 0 ? 1024 * (this.index - 1) + this.cursor : this.cursor;
        }
    }
}

