/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.lang;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.aoju.bus.core.collection.EnumerationIterator;
import org.aoju.bus.core.exception.InstrumentException;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.toolkit.ClassKit;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.core.toolkit.UriKit;

public class Scaner {
    private final String packageName;
    private final String packageNameWithDot;
    private final String packageDirName;
    private final String packagePath;
    private final Predicate<Class<?>> predicate;
    private final java.nio.charset.Charset charset;
    private final Set<Class<?>> classes = new HashSet();
    private boolean initialize;

    public Scaner() {
        this(null);
    }

    public Scaner(String packageName) {
        this(packageName, null);
    }

    public Scaner(String packageName, Predicate<Class<?>> predicate) {
        this(packageName, predicate, Charset.UTF_8);
    }

    public Scaner(String packageName, Predicate<Class<?>> predicate, java.nio.charset.Charset charset) {
        this.packageName = packageName = StringKit.nullToEmpty(packageName);
        this.packageNameWithDot = StringKit.addSuffixIfNot(packageName, ".");
        this.packageDirName = packageName.replace('.', File.separatorChar);
        this.packagePath = packageName.replace('.', '/');
        this.predicate = predicate;
        this.charset = charset;
    }

    public static Set<Class<?>> scanAllPackage() {
        return Scaner.scanAllPackage("", null);
    }

    public static Set<Class<?>> scanAllPackage(String packageName, Predicate<Class<?>> classFilter) {
        return new Scaner(packageName, classFilter).scan(true);
    }

    public static Set<Class<?>> scanPackage() {
        return Scaner.scanPackage("", null);
    }

    public static Set<Class<?>> scanPackage(String packageName) {
        return Scaner.scanPackage(packageName, null);
    }

    public static Set<Class<?>> scanPackage(String packageName, Predicate<Class<?>> predicate) {
        return new Scaner(packageName, predicate).scan();
    }

    public static Set<Class<?>> scanAllPackageByAnnotation(String packageName, Class<? extends Annotation> annotationClass) {
        return Scaner.scanAllPackage(packageName, clazz -> clazz.isAnnotationPresent(annotationClass));
    }

    public static Set<Class<?>> scanPackageByAnnotation(String packageName, Class<? extends Annotation> annotationClass) {
        return Scaner.scanPackage(packageName, clazz -> clazz.isAnnotationPresent(annotationClass));
    }

    public static Set<Class<?>> scanAllPackageBySuper(String packageName, Class<?> superClass) {
        return Scaner.scanAllPackage(packageName, clazz -> superClass.isAssignableFrom((Class<?>)clazz) && !superClass.equals(clazz));
    }

    public static Set<Class<?>> scanPackageBySuper(String packageName, Class<?> superClass) {
        return Scaner.scanPackage(packageName, clazz -> superClass.isAssignableFrom((Class<?>)clazz) && !superClass.equals(clazz));
    }

    public Set<Class<?>> scan() {
        return this.scan(false);
    }

    public Set<Class<?>> scan(boolean forceScanJavaClassPaths) {
        for (URL url : FileKit.getResourceIter(this.packagePath)) {
            switch (url.getProtocol()) {
                case "file": {
                    this.scanFile(new File(UriKit.decode(url.getFile(), this.charset.name())), null);
                    break;
                }
                case "jar": {
                    this.scanJar(UriKit.getJarFile(url));
                }
            }
        }
        if (forceScanJavaClassPaths || CollKit.isEmpty(this.classes)) {
            this.scanJavaClassPaths();
        }
        return Collections.unmodifiableSet(this.classes);
    }

    private void scanJavaClassPaths() {
        String[] javaClassPaths;
        for (String classPath : javaClassPaths = ClassKit.getJavaClassPaths()) {
            classPath = UriKit.decode(classPath, Charset.systemCharsetName());
            this.scanFile(new File(classPath), null);
        }
    }

    private void scanFile(File file, String rootDir) {
        File[] files;
        if (file.isFile()) {
            String fileName = file.getAbsolutePath();
            if (fileName.endsWith(".class")) {
                String className = fileName.substring(rootDir.length(), fileName.length() - 6).replace(File.separatorChar, '.');
                this.addIfAccept(className);
            } else if (fileName.endsWith(".jar")) {
                try {
                    this.scanJar(new JarFile(file));
                }
                catch (IOException e) {
                    throw new InstrumentException(e);
                }
            }
        } else if (file.isDirectory() && null != (files = file.listFiles())) {
            for (File subFile : files) {
                this.scanFile(subFile, null == rootDir ? this.subPathBeforePackage(file) : rootDir);
            }
        }
    }

    private void scanJar(JarFile jar) {
        for (JarEntry entry : new EnumerationIterator<JarEntry>(jar.entries())) {
            String name = StringKit.removePrefix(entry.getName(), "/");
            if (!StringKit.isEmpty(this.packagePath) && !name.startsWith(this.packagePath) || !name.endsWith(".class") || entry.isDirectory()) continue;
            String className = name.substring(0, name.length() - 6).replace('/', '.');
            this.addIfAccept(this.loadClass(className));
        }
    }

    public void setInitialize(boolean initialize) {
        this.initialize = initialize;
    }

    private Class<?> loadClass(String className) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className, this.initialize, ClassKit.getClassLoader());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (ClassNotFoundException | UnsupportedClassVersionError throwable) {
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return clazz;
    }

    private void addIfAccept(String className) {
        int packageLen;
        if (StringKit.isBlank(className)) {
            return;
        }
        int classLen = className.length();
        if (classLen == (packageLen = this.packageName.length())) {
            if (className.equals(this.packageName)) {
                this.addIfAccept(this.loadClass(className));
            }
        } else if (classLen > packageLen && className.startsWith(this.packageNameWithDot)) {
            this.addIfAccept(this.loadClass(className));
        }
    }

    private void addIfAccept(Class<?> clazz) {
        Predicate<Class<?>> classFilter;
        if (null != clazz && (null == (classFilter = this.predicate) || classFilter.test(clazz))) {
            this.classes.add(clazz);
        }
    }

    private String subPathBeforePackage(File file) {
        String filePath = file.getAbsolutePath();
        if (StringKit.isNotEmpty(this.packageDirName)) {
            filePath = StringKit.subBefore((CharSequence)filePath, this.packageDirName, true);
        }
        return StringKit.addSuffixIfNot(filePath, File.separator);
    }
}

