/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.loader;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Queue;
import org.aoju.bus.core.io.resource.Resource;
import org.aoju.bus.core.io.resource.UriResource;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.loader.Filter;
import org.aoju.bus.core.loader.Filters;
import org.aoju.bus.core.loader.Loader;
import org.aoju.bus.core.loader.ResourceLoader;
import org.aoju.bus.core.toolkit.UriKit;

public class FileLoader
extends ResourceLoader
implements Loader {
    private final URL context;
    private final File root;

    public FileLoader(File root) throws IOException {
        this(root.toURI().toURL(), root);
    }

    public FileLoader(URL fileURL) {
        this(fileURL, new File(UriKit.decode(fileURL.getPath(), Charset.UTF_8)));
    }

    public FileLoader(URL context, File root) {
        if (null == context) {
            throw new IllegalArgumentException("context must not be null");
        }
        if (null == root) {
            throw new IllegalArgumentException("root must not be null");
        }
        this.context = context;
        this.root = root;
    }

    @Override
    public Enumeration<Resource> load(String path, boolean recursively, Filter filter) {
        return new Enumerator(this.context, this.root, path, recursively, null != filter ? filter : Filters.ALWAYS);
    }

    private static class Enumerator
    extends ResourceLoader.ResourceEnumerator
    implements Enumeration<Resource> {
        private final URL context;
        private final boolean recursively;
        private final Filter filter;
        private final Queue<File> queue;

        Enumerator(URL context, File root, String path, boolean recursively, Filter filter) {
            this.context = context;
            this.recursively = recursively;
            this.filter = filter;
            this.queue = new LinkedList<File>();
            File file = new File(root, path);
            if (file.isDirectory()) {
                File[] files = file.listFiles();
                for (int i = 0; null != files && i < files.length; ++i) {
                    this.queue.offer(files[i]);
                }
            } else {
                this.queue.offer(file);
            }
        }

        @Override
        public boolean hasMoreElements() {
            if (null != this.next) {
                return true;
            }
            while (!this.queue.isEmpty()) {
                File file = this.queue.poll();
                if (!file.exists()) continue;
                if (file.isFile()) {
                    try {
                        String name = this.context.toURI().relativize(file.toURI()).toString();
                        URL url = new URL(this.context, name);
                        if (this.filter.filtrate(name, url)) {
                            this.next = new UriResource(url, name);
                            return true;
                        }
                    }
                    catch (Exception e) {
                        throw new IllegalStateException(e);
                    }
                }
                if (!file.isDirectory() || !this.recursively) continue;
                File[] files = file.listFiles();
                for (int i = 0; null != files && i < files.length; ++i) {
                    this.queue.offer(files[i]);
                }
                return this.hasMoreElements();
            }
            return false;
        }
    }
}

