/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.toolkit;

import java.awt.Color;
import java.math.BigInteger;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.core.toolkit.StringKit;

public class HexKit {
    public static boolean isHexNumber(String value) {
        int index = value.startsWith("-") ? 1 : 0;
        return value.startsWith("0x", index) || value.startsWith("0X", index) || value.startsWith("#", index);
    }

    public static char[] encodeHex(byte[] data) {
        return HexKit.encodeHex(data, true);
    }

    public static char[] encodeHex(String text, java.nio.charset.Charset charset) {
        return HexKit.encodeHex(StringKit.bytes((CharSequence)text, charset), true);
    }

    public static char[] encodeHex(byte[] data, boolean toLowerCase) {
        return HexKit.encodeHex(data, toLowerCase ? Normal.DIGITS_16_LOWER : Normal.DIGITS_16_UPPER);
    }

    public static String encodeHexStr(byte[] data) {
        return HexKit.encodeHexStr(data, true);
    }

    public static String encodeHexStr(String data, java.nio.charset.Charset charset) {
        return HexKit.encodeHexStr(StringKit.bytes((CharSequence)data, charset), true);
    }

    public static String encodeHexStr(String data) {
        return HexKit.encodeHexStr(data, Charset.UTF_8);
    }

    public static String encodeHexStr(byte[] data, boolean toLowerCase) {
        return HexKit.encodeHexStr(data, toLowerCase ? Normal.DIGITS_16_LOWER : Normal.DIGITS_16_UPPER);
    }

    public static String decodeHexStr(String hexStr) {
        return HexKit.decodeHexStr(hexStr, Charset.UTF_8);
    }

    public static String decodeHexStr(String hexStr, java.nio.charset.Charset charset) {
        if (StringKit.isEmpty(hexStr)) {
            return hexStr;
        }
        return StringKit.toString(HexKit.decodeHex(hexStr), charset);
    }

    public static String decodeHexStr(char[] hexData, java.nio.charset.Charset charset) {
        return StringKit.toString(HexKit.decodeHex(hexData), charset);
    }

    public static byte[] decodeHex(char[] hexData) {
        return HexKit.decodeHex(String.valueOf(hexData));
    }

    public static byte[] decodeHex(CharSequence hexData) {
        if (StringKit.isEmpty((CharSequence)hexData)) {
            return null;
        }
        int len = (hexData = StringKit.cleanBlank((CharSequence)hexData)).length();
        if ((len & 1) != 0) {
            hexData = "0" + (CharSequence)hexData;
            len = hexData.length();
        }
        byte[] out = new byte[len >> 1];
        int i = 0;
        int j = 0;
        while (j < len) {
            int f = HexKit.toDigit(hexData.charAt(j), j) << 4;
            f |= HexKit.toDigit(hexData.charAt(++j), j);
            ++j;
            out[i] = (byte)(f & 0xFF);
            ++i;
        }
        return out;
    }

    public static String encodeColor(Color color) {
        return HexKit.encodeColor(color, "#");
    }

    public static String encodeColor(Color color, String prefix) {
        StringBuffer builder = new StringBuffer(prefix);
        String colorHex = Integer.toHexString(color.getRed());
        if (1 == colorHex.length()) {
            builder.append('0');
        }
        builder.append(colorHex);
        colorHex = Integer.toHexString(color.getGreen());
        if (1 == colorHex.length()) {
            builder.append('0');
        }
        builder.append(colorHex);
        colorHex = Integer.toHexString(color.getBlue());
        if (1 == colorHex.length()) {
            builder.append('0');
        }
        builder.append(colorHex);
        return builder.toString();
    }

    public static Color decodeColor(String hexColor) {
        return Color.decode(hexColor);
    }

    public static String toUnicodeHex(int value) {
        StringBuilder builder = new StringBuilder(6);
        builder.append("\\u");
        String hex = Integer.toHexString(value);
        int len = hex.length();
        if (len < 4) {
            builder.append("0000", 0, 4 - len);
        }
        builder.append(hex);
        return builder.toString();
    }

    public static String toUnicodeHex(char ch) {
        StringBuilder sb = new StringBuilder(6);
        sb.append("\\u");
        sb.append(Normal.DIGITS_16_LOWER[ch >> 12 & 0xF]);
        sb.append(Normal.DIGITS_16_LOWER[ch >> 8 & 0xF]);
        sb.append(Normal.DIGITS_16_LOWER[ch >> 4 & 0xF]);
        sb.append(Normal.DIGITS_16_LOWER[ch & 0xF]);
        return sb.toString();
    }

    private static String encodeHexStr(byte[] data, char[] toDigits) {
        return new String(HexKit.encodeHex(data, toDigits));
    }

    private static char[] encodeHex(byte[] data, char[] toDigits) {
        int l = data.length;
        char[] out = new char[l << 1];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            out[j++] = toDigits[(0xF0 & data[i]) >>> 4];
            out[j++] = toDigits[0xF & data[i]];
        }
        return out;
    }

    private static int toDigit(char ch, int index) {
        int digit = Character.digit(ch, 16);
        if (digit == -1) {
            throw new RuntimeException("Illegal hexadecimal character " + ch + " at index " + index);
        }
        return digit;
    }

    public static BigInteger toBigInteger(String hexStr) {
        if (null == hexStr) {
            return null;
        }
        return new BigInteger(hexStr, 16);
    }

    public static String format(String hexStr) {
        int length = hexStr.length();
        StringBuilder builder = new StringBuilder(length + length / 2);
        builder.append(hexStr.charAt(0)).append(hexStr.charAt(1));
        for (int i = 2; i < length - 1; i += 2) {
            builder.append(' ').append(hexStr.charAt(i)).append(hexStr.charAt(i + 1));
        }
        return builder.toString();
    }

    public static void appendHex(StringBuilder builder, byte b, boolean toLowerCase) {
        char[] toDigits = toLowerCase ? Normal.DIGITS_16_LOWER : Normal.DIGITS_16_UPPER;
        int high = (b & 0xF0) >>> 4;
        int low = b & 0xF;
        builder.append(toDigits[high]);
        builder.append(toDigits[low]);
    }
}

