/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.cron;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.aoju.bus.core.exception.CrontabException;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.cron.Scheduler;
import org.aoju.bus.cron.factory.CronTask;
import org.aoju.bus.cron.factory.Task;
import org.aoju.bus.cron.pattern.CronPattern;

public class Repertoire
implements Serializable {
    public static final int DEFAULT_CAPACITY = 10;
    private static final long serialVersionUID = 1L;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final List<String> ids;
    private final List<CronPattern> patterns;
    private final List<Task> tasks;
    private int size;

    public Repertoire() {
        this(10);
    }

    public Repertoire(int initialCapacity) {
        this.ids = new ArrayList<String>(initialCapacity);
        this.patterns = new ArrayList<CronPattern>(initialCapacity);
        this.tasks = new ArrayList<Task>(initialCapacity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Repertoire add(String id, CronPattern pattern, Task task) {
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            if (this.ids.contains(id)) {
                throw new CrontabException("Id [{}] has been existed!", id);
            }
            this.ids.add(id);
            this.patterns.add(pattern);
            this.tasks.add(task);
            ++this.size;
        }
        finally {
            writeLock.unlock();
        }
        return this;
    }

    public List<String> getIds() {
        Lock readLock = this.lock.readLock();
        readLock.lock();
        try {
            List<String> list = Collections.unmodifiableList(this.ids);
            return list;
        }
        finally {
            readLock.unlock();
        }
    }

    public List<CronPattern> getPatterns() {
        Lock readLock = this.lock.readLock();
        readLock.lock();
        try {
            List<CronPattern> list = Collections.unmodifiableList(this.patterns);
            return list;
        }
        finally {
            readLock.unlock();
        }
    }

    public List<Task> getTasks() {
        Lock readLock = this.lock.readLock();
        readLock.lock();
        try {
            List<Task> list = Collections.unmodifiableList(this.tasks);
            return list;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(String id) {
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            int index = this.ids.indexOf(id);
            if (index < 0) {
                boolean bl = false;
                return bl;
            }
            this.tasks.remove(index);
            this.patterns.remove(index);
            this.ids.remove(index);
            --this.size;
        }
        finally {
            writeLock.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updatePattern(String id, CronPattern pattern) {
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            int index = this.ids.indexOf(id);
            if (index > -1) {
                this.patterns.set(index, pattern);
                boolean bl = true;
                return bl;
            }
        }
        finally {
            writeLock.unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task getTask(int index) {
        Lock readLock = this.lock.readLock();
        readLock.lock();
        try {
            Task task = this.tasks.get(index);
            return task;
        }
        finally {
            readLock.unlock();
        }
    }

    public Task getTask(String id) {
        int index = this.ids.indexOf(id);
        if (index > -1) {
            return this.getTask(index);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CronPattern getPattern(int index) {
        Lock readLock = this.lock.readLock();
        readLock.lock();
        try {
            CronPattern cronPattern = this.patterns.get(index);
            return cronPattern;
        }
        finally {
            readLock.unlock();
        }
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size < 1;
    }

    public CronPattern getPattern(String id) {
        int index = this.ids.indexOf(id);
        if (index > -1) {
            return this.getPattern(index);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeTaskIfMatch(Scheduler scheduler, long millis) {
        Lock readLock = this.lock.readLock();
        readLock.lock();
        try {
            this.executeTaskIfMatchInternal(scheduler, millis);
        }
        finally {
            readLock.unlock();
        }
    }

    protected void executeTaskIfMatchInternal(Scheduler scheduler, long millis) {
        for (int i = 0; i < this.size; ++i) {
            if (!this.patterns.get(i).match(scheduler.config.timezone, millis, scheduler.config.matchSecond)) continue;
            scheduler.manager.spawnExecutor(new CronTask(this.ids.get(i), this.patterns.get(i), this.tasks.get(i)));
        }
    }

    public String toString() {
        StringBuilder builder = StringKit.builder(new CharSequence[0]);
        for (int i = 0; i < this.size; ++i) {
            builder.append(StringKit.format((CharSequence)"[{}] [{}] [{}]\n", this.ids.get(i), this.patterns.get(i), this.tasks.get(i)));
        }
        return builder.toString();
    }
}

