/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.cron.factory;

import java.lang.reflect.Method;
import org.aoju.bus.core.exception.CrontabException;
import org.aoju.bus.core.toolkit.ClassKit;
import org.aoju.bus.core.toolkit.ReflectKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.cron.factory.Task;

public class InvokeTask
implements Task {
    private final Object obj;
    private final Method method;

    public InvokeTask(String classNameWithMethodName) {
        int splitIndex = classNameWithMethodName.lastIndexOf(35);
        if (splitIndex <= 0) {
            splitIndex = classNameWithMethodName.lastIndexOf(46);
        }
        if (splitIndex <= 0) {
            throw new CrontabException("Invalid classNameWithMethodName [{}]!", classNameWithMethodName);
        }
        String className = classNameWithMethodName.substring(0, splitIndex);
        if (StringKit.isBlank(className)) {
            throw new IllegalArgumentException("Class name is blank !");
        }
        Class clazz = ClassKit.loadClass(className);
        if (null == clazz) {
            throw new IllegalArgumentException("Load class with name of [" + className + "] fail !");
        }
        this.obj = ReflectKit.newInstanceIfPossible(clazz);
        String methodName = classNameWithMethodName.substring(splitIndex + 1);
        if (StringKit.isBlank(methodName)) {
            throw new IllegalArgumentException("Method name is blank !");
        }
        this.method = ClassKit.getPublicMethod(clazz, methodName, new Class[0]);
        if (null == this.method) {
            throw new IllegalArgumentException("No method with name of [" + methodName + "] !");
        }
    }

    @Override
    public void execute() {
        try {
            ReflectKit.invoke(this.obj, this.method, new Object[0]);
        }
        catch (CrontabException e) {
            throw new CrontabException(e.getCause());
        }
    }
}

