/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.cron.pattern.parser;

import java.util.ArrayList;
import java.util.List;
import org.aoju.bus.core.exception.CrontabException;
import org.aoju.bus.core.lang.Fields;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.core.toolkit.MathKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.cron.pattern.Part;
import org.aoju.bus.cron.pattern.matcher.AlwaysTrueMatcher;
import org.aoju.bus.cron.pattern.matcher.BoolArrayMatcher;
import org.aoju.bus.cron.pattern.matcher.DayOfMonthMatcher;
import org.aoju.bus.cron.pattern.matcher.PartMatcher;
import org.aoju.bus.cron.pattern.matcher.YearValueMatcher;

public class PartParser {
    private final Part part;

    public PartParser(Part part) {
        this.part = part;
    }

    public static PartParser of(Part part) {
        return new PartParser(part);
    }

    private static boolean isMatchAllStr(String value) {
        return 1 == value.length() && ("*".equals(value) || "?".equals(value));
    }

    public PartMatcher parse(String value) {
        if (PartParser.isMatchAllStr(value)) {
            return new AlwaysTrueMatcher();
        }
        List<Integer> values = this.parseArray(value);
        if (values.size() == 0) {
            throw new CrontabException("Invalid part value: [{}]", value);
        }
        switch (this.part) {
            case DAY_OF_MONTH: {
                return new DayOfMonthMatcher(values);
            }
            case YEAR: {
                return new YearValueMatcher(values);
            }
        }
        return new BoolArrayMatcher(values);
    }

    private List<Integer> parseArray(String value) {
        ArrayList<Integer> values = new ArrayList<Integer>();
        List<String> parts = StringKit.split((CharSequence)value, ',');
        for (String part : parts) {
            CollKit.addAllIfNotContains(values, this.parseStep(part));
        }
        return values;
    }

    private List<Integer> parseStep(String value) {
        List<Integer> results;
        List<String> parts = StringKit.split((CharSequence)value, '/');
        int size = parts.size();
        if (size == 1) {
            results = this.parseRange(value, -1);
        } else if (size == 2) {
            int step = this.parseNumber(parts.get(1));
            if (step < 1) {
                throw new CrontabException("Non positive divisor for field: [{}]", value);
            }
            results = this.parseRange(parts.get(0), step);
        } else {
            throw new CrontabException("Invalid syntax of field: [{}]", value);
        }
        return results;
    }

    private List<Integer> parseRange(String value, int step) {
        ArrayList<Integer> results = new ArrayList<Integer>();
        if (value.length() <= 2) {
            int minValue = this.part.getMin();
            if (!PartParser.isMatchAllStr(value)) {
                minValue = Math.max(minValue, this.parseNumber(value));
            } else if (step < 1) {
                step = 1;
            }
            if (step > 0) {
                int maxValue = this.part.getMax();
                if (minValue > maxValue) {
                    throw new CrontabException("Invalid value {} > {}", minValue, maxValue);
                }
                for (int i = minValue; i <= maxValue; i += step) {
                    results.add(i);
                }
            } else {
                results.add(minValue);
            }
            return results;
        }
        List<String> parts = StringKit.split((CharSequence)value, '-');
        int size = parts.size();
        if (size == 1) {
            int v1 = this.parseNumber(value);
            if (step > 0) {
                MathKit.appendRange(v1, this.part.getMax(), step, results);
            } else {
                results.add(v1);
            }
        } else if (size == 2) {
            int v1 = this.parseNumber(parts.get(0));
            int v2 = this.parseNumber(parts.get(1));
            if (step < 1) {
                step = 1;
            }
            if (v1 < v2) {
                MathKit.appendRange(v1, v2, step, results);
            } else if (v1 > v2) {
                MathKit.appendRange(v1, this.part.getMax(), step, results);
                MathKit.appendRange(this.part.getMin(), v2, step, results);
            } else {
                MathKit.appendRange(v1, this.part.getMax(), step, results);
            }
        } else {
            throw new CrontabException("Invalid syntax of field: [{}]", value);
        }
        return results;
    }

    private int parseNumber(String value) throws CrontabException {
        int i;
        try {
            i = Integer.parseInt(value);
        }
        catch (NumberFormatException ignore) {
            i = this.parseAlias(value);
        }
        if (i < 0) {
            i += this.part.getMax();
        }
        if (Part.DAY_OF_WEEK.equals((Object)this.part) && Fields.Week.Sun.getKey() == i) {
            i = Fields.Week.Sun.ordinal();
        }
        return this.part.checkValue(i);
    }

    private int parseAlias(String name) throws CrontabException {
        if ("L".equalsIgnoreCase(name)) {
            return this.part.getMax();
        }
        switch (this.part) {
            case MONTH: {
                return Fields.Month.valueOf(name).ordinal();
            }
            case DAY_OF_WEEK: {
                return Fields.Month.valueOf(name).ordinal();
            }
        }
        throw new CrontabException("Invalid alias value: [{}]", name);
    }
}

