/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.crypto.symmetric;

import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.aoju.bus.core.lang.Algorithm;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.crypto.Builder;
import org.aoju.bus.crypto.Mode;
import org.aoju.bus.crypto.Padding;
import org.aoju.bus.crypto.symmetric.Crypto;

public class AES
extends Crypto {
    private static final long serialVersionUID = 1L;

    public AES() {
        super(Algorithm.AES);
    }

    public AES(byte[] key) {
        super(Algorithm.AES, key);
    }

    public AES(SecretKey key) {
        super(Algorithm.AES, key);
    }

    public AES(Mode mode, Padding padding) {
        this(mode.name(), padding.name());
    }

    public AES(Mode mode, Padding padding, byte[] key) {
        this(mode, padding, key, null);
    }

    public AES(Mode mode, Padding padding, byte[] key, byte[] iv) {
        this(mode.name(), padding.name(), key, iv);
    }

    public AES(Mode mode, Padding padding, SecretKey key) {
        this(mode, padding, key, (AlgorithmParameterSpec)null);
    }

    public AES(Mode mode, Padding padding, SecretKey key, byte[] iv) {
        this(mode, padding, key, (AlgorithmParameterSpec)(ArrayKit.isEmpty(iv) ? null : new IvParameterSpec(iv)));
    }

    public AES(Mode mode, Padding padding, SecretKey key, AlgorithmParameterSpec paramsSpec) {
        this(mode.name(), padding.name(), key, paramsSpec);
    }

    public AES(String mode, String padding) {
        this(mode, padding, (byte[])null);
    }

    public AES(String mode, String padding, byte[] key) {
        this(mode, padding, key, null);
    }

    public AES(String mode, String padding, byte[] key, byte[] iv) {
        this(mode, padding, Builder.generateKey(Algorithm.AES.getValue(), key), (AlgorithmParameterSpec)(ArrayKit.isEmpty(iv) ? null : new IvParameterSpec(iv)));
    }

    public AES(String mode, String padding, SecretKey key) {
        this(mode, padding, key, null);
    }

    public AES(String mode, String padding, SecretKey key, AlgorithmParameterSpec paramsSpec) {
        super(StringKit.format((CharSequence)"AES/{}/{}", mode, padding), key, paramsSpec);
    }
}

