/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.crypto.symmetric;

import javax.crypto.spec.IvParameterSpec;
import org.aoju.bus.core.toolkit.RandomKit;
import org.aoju.bus.crypto.Builder;
import org.aoju.bus.crypto.symmetric.Crypto;

public class ZUC
extends Crypto {
    private static final long serialVersionUID = 1L;

    public ZUC(ZUCAlgorithm algorithm, byte[] key, byte[] iv) {
        super(algorithm.value, Builder.generateKey(algorithm.value, key), ZUC.generateIvParam(algorithm, iv));
    }

    public static byte[] generateKey(ZUCAlgorithm algorithm) {
        return Builder.generateKey(algorithm.value).getEncoded();
    }

    private static IvParameterSpec generateIvParam(ZUCAlgorithm algorithm, byte[] iv) {
        if (null == iv) {
            switch (algorithm) {
                case ZUC_128: {
                    iv = RandomKit.randomBytes(16);
                    break;
                }
                case ZUC_256: {
                    iv = RandomKit.randomBytes(25);
                }
            }
        }
        return new IvParameterSpec(iv);
    }

    public static enum ZUCAlgorithm {
        ZUC_128("ZUC-128"),
        ZUC_256("ZUC-256");

        private final String value;

        private ZUCAlgorithm(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

