/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.extra.json;

import org.aoju.bus.core.exception.InstrumentException;
import org.aoju.bus.core.instance.Instances;
import org.aoju.bus.core.toolkit.ClassKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.extra.json.JsonProvider;
import org.aoju.bus.logger.Logger;

public class JsonFactory {
    public static JsonProvider get() {
        Instances.singletion(JsonFactory.class);
        return JsonFactory.create();
    }

    public static JsonProvider create() {
        JsonProvider engine = ClassKit.loadFirstAvailable(JsonProvider.class);
        if (null == engine) {
            throw new InstrumentException("No json jar found ! Please add one of it to your project !");
        }
        Logger.debug("Use [{}] provider as default.", StringKit.removeSuffix(engine.getClass().getSimpleName(), "Provider"));
        return engine;
    }
}

