/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.goalie.handler;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.goalie.annotation.TerminalVersion;
import org.springframework.web.servlet.mvc.condition.AbstractRequestCondition;

public class ApiVersionRequestCondition
extends AbstractRequestCondition<ApiVersionRequestCondition> {
    private final Set<TerminalVersionExpression> expressions;

    protected ApiVersionRequestCondition(Set<TerminalVersionExpression> expressions) {
        this.expressions = expressions;
    }

    public ApiVersionRequestCondition(String[] stringExpressions) {
        this.expressions = Collections.unmodifiableSet(ApiVersionRequestCondition.parseByExpression(stringExpressions));
    }

    public ApiVersionRequestCondition(TerminalVersion[] terminalVersions) {
        this.expressions = Collections.unmodifiableSet(ApiVersionRequestCondition.parseByTerminalVersion(terminalVersions));
    }

    private static Set<TerminalVersionExpression> parseByTerminalVersion(TerminalVersion[] terminalVersions) {
        LinkedHashSet<TerminalVersionExpression> expressions = new LinkedHashSet<TerminalVersionExpression>();
        for (TerminalVersion terminalVersion : terminalVersions) {
            expressions.add(new TerminalVersionExpression(terminalVersion.terminals(), terminalVersion.version(), terminalVersion.op()));
        }
        return expressions;
    }

    private static Set<TerminalVersionExpression> parseByExpression(String[] stringExpressions) {
        LinkedHashSet<TerminalVersionExpression> terminalExpressions = new LinkedHashSet<TerminalVersionExpression>();
        for (String expression : stringExpressions) {
            String regex = "([\\d,*]+)([!=<>]*)([\\d\\.]*)";
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(expression);
            if (!matcher.find()) continue;
            int[] terminals = new int[]{};
            String version = "";
            TerminalVersion.Version operator = TerminalVersion.Version.NIL;
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                String content = matcher.group(i);
                if (i == 1) {
                    if (!StringKit.isNotBlank(content) || content.equalsIgnoreCase("*")) continue;
                    String[] split = content.split(",");
                    terminals = new int[split.length];
                    for (int j = 0; j < split.length; ++j) {
                        try {
                            terminals[j] = Integer.parseInt(split[j]);
                            continue;
                        }
                        catch (Exception e) {
                            throw new IllegalArgumentException("is there a wrong number for terminal type?");
                        }
                    }
                    continue;
                }
                if (i == 2) {
                    operator = TerminalVersion.Version.parse(content);
                    if (null != operator) continue;
                    throw new IllegalArgumentException("check the versionOperator!!!");
                }
                if (i != 3) continue;
                version = content;
            }
            terminalExpressions.add(new TerminalVersionExpression(terminals, version, operator));
        }
        return terminalExpressions;
    }

    protected Collection<?> getContent() {
        return this.expressions;
    }

    protected String getToStringInfix() {
        return " && ";
    }

    public ApiVersionRequestCondition combine(ApiVersionRequestCondition other) {
        LinkedHashSet<TerminalVersionExpression> set = new LinkedHashSet<TerminalVersionExpression>(this.expressions);
        set.addAll(other.expressions);
        return new ApiVersionRequestCondition(set);
    }

    public ApiVersionRequestCondition getMatchingCondition(HttpServletRequest request) {
        for (TerminalVersionExpression expression : this.expressions) {
            if (expression.match(request)) continue;
            return null;
        }
        return this;
    }

    public int compareTo(ApiVersionRequestCondition other, HttpServletRequest request) {
        return 0;
    }

    static class TerminalVersionExpression {
        public static final String HEADER_VERSION = "cv";
        public static final String HEADER_TERMINAL = "terminal";
        private final String version;
        private final TerminalVersion.Version operator;
        private int[] terminals;

        public TerminalVersionExpression(int[] terminals, String version, TerminalVersion.Version operator) {
            Arrays.sort(terminals);
            if (StringKit.isNotBlank(version) && operator == TerminalVersion.Version.NIL) {
                throw new IllegalArgumentException("opetator cant be nil when version is existing...");
            }
            this.terminals = terminals;
            this.version = version;
            this.operator = operator;
        }

        public int[] getTerminals() {
            return this.terminals;
        }

        public void setTerminals(int[] terminals) {
            this.terminals = terminals;
        }

        public String getVersion() {
            return this.version;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            if (null != this.terminals && this.terminals.length != 0) {
                builder.append(ArrayKit.join((Object)this.terminals, (CharSequence)","));
            } else {
                builder.append("*");
            }
            builder.append(this.operator.getCode());
            if (StringKit.isNotBlank(this.version)) {
                builder.append(this.version);
            }
            return builder.toString();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (null != obj && obj instanceof TerminalVersionExpression) {
                return this.toString().equalsIgnoreCase(obj.toString());
            }
            return false;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public final boolean match(HttpServletRequest request) {
            int terminal;
            int i;
            if (null != this.terminals && this.terminals.length > 0 && (i = Arrays.binarySearch(this.terminals, terminal = this.getTerminal(request))) < 0) {
                return false;
            }
            if (null != this.operator && this.operator != TerminalVersion.Version.NIL) {
                String clientVersion = this.getVersion(request);
                String checkVersion = this.getVersion();
                if (StringKit.isBlank(clientVersion)) {
                    return false;
                }
                int i2 = clientVersion.compareToIgnoreCase(checkVersion);
                switch (this.operator) {
                    case GT: {
                        return i2 > 0;
                    }
                    case GTE: {
                        return i2 >= 0;
                    }
                    case LT: {
                        return i2 < 0;
                    }
                    case LTE: {
                        return i2 <= 0;
                    }
                    case EQ: {
                        return i2 == 0;
                    }
                    case NE: {
                        return i2 != 0;
                    }
                }
            }
            return true;
        }

        private int getTerminal(HttpServletRequest request) {
            String value = request.getHeader(HEADER_TERMINAL);
            try {
                return Integer.parseInt(value);
            }
            catch (Exception e) {
                return -1;
            }
        }

        private String getVersion(HttpServletRequest request) {
            return request.getHeader(HEADER_VERSION);
        }
    }
}

