/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.unix.aix.drivers;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.core.lang.RegEx;
import org.aoju.bus.core.lang.tuple.Pair;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Executor;

@ThreadSafe
public final class Lssrad {
    public static Map<Integer, Pair<Integer, Integer>> queryNodesPackages() {
        int node = 0;
        int slot = 0;
        HashMap<Integer, Pair<Integer, Integer>> nodeMap = new HashMap<Integer, Pair<Integer, Integer>>();
        List<String> lssrad = Executor.runNative("lssrad -av");
        if (!lssrad.isEmpty()) {
            lssrad.remove(0);
        }
        for (String s : lssrad) {
            String t = s.trim();
            if (t.isEmpty()) continue;
            if (Character.isDigit(s.charAt(0))) {
                node = Builder.parseIntOrDefault(t, 0);
                continue;
            }
            if (t.contains(".")) {
                String[] split = RegEx.SPACES.split(t, 3);
                slot = Builder.parseIntOrDefault(split[0], 0);
                t = split.length > 2 ? split[2] : "";
            }
            for (Integer proc : Builder.parseHyphenatedIntList(t)) {
                nodeMap.put(proc, Pair.of(node, slot));
            }
        }
        return nodeMap;
    }
}

