/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.unix.freebsd.software;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.unix.LibCAPI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Executor;
import org.aoju.bus.health.Memoize;
import org.aoju.bus.health.builtin.software.AbstractOSProcess;
import org.aoju.bus.health.builtin.software.OSProcess;
import org.aoju.bus.health.builtin.software.OSThread;
import org.aoju.bus.health.unix.FreeBsdLibc;
import org.aoju.bus.health.unix.freebsd.BsdSysctlKit;
import org.aoju.bus.health.unix.freebsd.ProcstatKit;
import org.aoju.bus.health.unix.freebsd.software.FreeBsdOSThread;
import org.aoju.bus.health.unix.freebsd.software.FreeBsdOperatingSystem;
import org.aoju.bus.logger.Logger;

@ThreadSafe
public class FreeBsdOSProcess
extends AbstractOSProcess {
    static final String PS_THREAD_COLUMNS = Arrays.stream(PsThreadColumns.values()).map(Enum::name).map(String::toLowerCase).collect(Collectors.joining(","));
    private static final int ARGMAX = BsdSysctlKit.sysctl("kern.argmax", 0);
    private final Supplier<Integer> bitness = Memoize.memoize(this::queryBitness);
    private final Supplier<List<String>> arguments = Memoize.memoize(this::queryArguments);
    private final Supplier<Map<String, String>> environmentVariables = Memoize.memoize(this::queryEnvironmentVariables);
    private String name;
    private String path = "";
    private String user;
    private String userID;
    private String group;
    private String groupID;
    private OSProcess.State state = OSProcess.State.INVALID;
    private int parentProcessID;
    private int threadCount;
    private int priority;
    private long virtualSize;
    private long residentSetSize;
    private long kernelTime;
    private long userTime;
    private long startTime;
    private long upTime;
    private long bytesRead;
    private long bytesWritten;
    private long minorFaults;
    private long majorFaults;
    private long contextSwitches;
    private String commandLineBackup;
    private final Supplier<String> commandLine = Memoize.memoize(this::queryCommandLine);

    public FreeBsdOSProcess(int pid, Map<FreeBsdOperatingSystem.PsKeywords, String> psMap) {
        super(pid);
        this.updateAttributes(psMap);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getCommandLine() {
        return this.commandLine.get();
    }

    private String queryCommandLine() {
        String cl = String.join((CharSequence)" ", this.getArguments());
        return cl.isEmpty() ? this.commandLineBackup : cl;
    }

    @Override
    public List<String> getArguments() {
        return this.arguments.get();
    }

    private List<String> queryArguments() {
        if (ARGMAX > 0) {
            int[] mib = new int[]{1, 14, 7, this.getProcessID()};
            Memory m = new Memory((long)ARGMAX);
            LibCAPI.size_t.ByReference size = new LibCAPI.size_t.ByReference(new LibCAPI.size_t((long)ARGMAX));
            if (FreeBsdLibc.INSTANCE.sysctl(mib, mib.length, (Pointer)m, size, null, LibCAPI.size_t.ZERO) == 0) {
                return Collections.unmodifiableList(Builder.parseByteArrayToStrings(m.getByteArray(0L, size.getValue().intValue())));
            }
            Logger.warn("Failed sysctl call for process arguments (kern.proc.args), process {} may not exist. Error code: {}", this.getProcessID(), Native.getLastError());
        }
        return Collections.emptyList();
    }

    @Override
    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables.get();
    }

    private Map<String, String> queryEnvironmentVariables() {
        if (ARGMAX > 0) {
            int[] mib = new int[]{1, 14, 35, this.getProcessID()};
            Memory m = new Memory((long)ARGMAX);
            LibCAPI.size_t.ByReference size = new LibCAPI.size_t.ByReference(new LibCAPI.size_t((long)ARGMAX));
            if (FreeBsdLibc.INSTANCE.sysctl(mib, mib.length, (Pointer)m, size, null, LibCAPI.size_t.ZERO) == 0) {
                return Collections.unmodifiableMap(Builder.parseByteArrayToStringMap(m.getByteArray(0L, size.getValue().intValue())));
            }
            Logger.warn("Failed sysctl call for process environment variables (kern.proc.env), process {} may not exist. Error code: {}", this.getProcessID(), Native.getLastError());
        }
        return Collections.emptyMap();
    }

    @Override
    public String getCurrentWorkingDirectory() {
        return ProcstatKit.getCwd(this.getProcessID());
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public String getUserID() {
        return this.userID;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public String getGroupID() {
        return this.groupID;
    }

    @Override
    public OSProcess.State getState() {
        return this.state;
    }

    @Override
    public int getParentProcessID() {
        return this.parentProcessID;
    }

    @Override
    public int getThreadCount() {
        return this.threadCount;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public long getVirtualSize() {
        return this.virtualSize;
    }

    @Override
    public long getResidentSetSize() {
        return this.residentSetSize;
    }

    @Override
    public long getKernelTime() {
        return this.kernelTime;
    }

    @Override
    public long getUserTime() {
        return this.userTime;
    }

    @Override
    public long getUpTime() {
        return this.upTime;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public long getBytesRead() {
        return this.bytesRead;
    }

    @Override
    public long getBytesWritten() {
        return this.bytesWritten;
    }

    @Override
    public long getOpenFiles() {
        return ProcstatKit.getOpenFiles(this.getProcessID());
    }

    @Override
    public int getBitness() {
        return this.bitness.get();
    }

    @Override
    public long getAffinityMask() {
        long bitMask = 0L;
        String cpuset = Executor.getFirstAnswer("cpuset -gp " + this.getProcessID());
        String[] split = cpuset.split(":");
        if (split.length > 1) {
            String[] bits;
            for (String bit : bits = split[1].split(",")) {
                int bitToSet = Builder.parseIntOrDefault(bit.trim(), -1);
                if (bitToSet < 0) continue;
                bitMask |= 1L << bitToSet;
            }
        }
        return bitMask;
    }

    private int queryBitness() {
        int[] mib = new int[]{1, 14, 9, this.getProcessID()};
        Memory abi = new Memory(32L);
        LibCAPI.size_t.ByReference size = new LibCAPI.size_t.ByReference(new LibCAPI.size_t(32L));
        if (0 == FreeBsdLibc.INSTANCE.sysctl(mib, mib.length, (Pointer)abi, size, null, LibCAPI.size_t.ZERO)) {
            String elf = abi.getString(0L);
            if (elf.contains("ELF32")) {
                return 32;
            }
            if (elf.contains("ELF64")) {
                return 64;
            }
        }
        return 0;
    }

    @Override
    public List<OSThread> getThreadDetails() {
        List<String> threadList;
        ArrayList<OSThread> threads = new ArrayList<OSThread>();
        String psCommand = "ps -awwxo " + PS_THREAD_COLUMNS + " -H";
        if (this.getProcessID() >= 0) {
            psCommand = psCommand + " -p " + this.getProcessID();
        }
        if ((threadList = Executor.runNative(psCommand)).size() > 1) {
            threadList.remove(0);
            for (String thread : threadList) {
                Map<PsThreadColumns, String> threadMap = Builder.stringToEnumMap(PsThreadColumns.class, thread.trim(), ' ');
                if (!threadMap.containsKey((Object)PsThreadColumns.PRI)) continue;
                threads.add(new FreeBsdOSThread(this.getProcessID(), threadMap));
            }
        }
        return threads;
    }

    @Override
    public long getMinorFaults() {
        return this.minorFaults;
    }

    @Override
    public long getMajorFaults() {
        return this.majorFaults;
    }

    @Override
    public long getContextSwitches() {
        return this.contextSwitches;
    }

    @Override
    public boolean updateAttributes() {
        Map<FreeBsdOperatingSystem.PsKeywords, String> psMap;
        String psCommand = "ps -awwxo " + FreeBsdOperatingSystem.PS_COMMAND_ARGS + " -p " + this.getProcessID();
        List<String> procList = Executor.runNative(psCommand);
        if (procList.size() > 1 && (psMap = Builder.stringToEnumMap(FreeBsdOperatingSystem.PsKeywords.class, procList.get(1).trim(), ' ')).containsKey((Object)FreeBsdOperatingSystem.PsKeywords.ARGS)) {
            return this.updateAttributes(psMap);
        }
        this.state = OSProcess.State.INVALID;
        return false;
    }

    private boolean updateAttributes(Map<FreeBsdOperatingSystem.PsKeywords, String> psMap) {
        long now = System.currentTimeMillis();
        switch (psMap.get((Object)FreeBsdOperatingSystem.PsKeywords.STATE).charAt(0)) {
            case 'R': {
                this.state = OSProcess.State.RUNNING;
                break;
            }
            case 'I': 
            case 'S': {
                this.state = OSProcess.State.SLEEPING;
                break;
            }
            case 'D': 
            case 'L': 
            case 'U': {
                this.state = OSProcess.State.WAITING;
                break;
            }
            case 'Z': {
                this.state = OSProcess.State.ZOMBIE;
                break;
            }
            case 'T': {
                this.state = OSProcess.State.STOPPED;
                break;
            }
            default: {
                this.state = OSProcess.State.OTHER;
            }
        }
        this.parentProcessID = Builder.parseIntOrDefault(psMap.get((Object)FreeBsdOperatingSystem.PsKeywords.PPID), 0);
        this.user = psMap.get((Object)FreeBsdOperatingSystem.PsKeywords.USER);
        this.userID = psMap.get((Object)FreeBsdOperatingSystem.PsKeywords.UID);
        this.group = psMap.get((Object)FreeBsdOperatingSystem.PsKeywords.GROUP);
        this.groupID = psMap.get((Object)FreeBsdOperatingSystem.PsKeywords.GID);
        this.threadCount = Builder.parseIntOrDefault(psMap.get((Object)FreeBsdOperatingSystem.PsKeywords.NLWP), 0);
        this.priority = Builder.parseIntOrDefault(psMap.get((Object)FreeBsdOperatingSystem.PsKeywords.PRI), 0);
        this.virtualSize = Builder.parseLongOrDefault(psMap.get((Object)FreeBsdOperatingSystem.PsKeywords.VSZ), 0L) * 1024L;
        this.residentSetSize = Builder.parseLongOrDefault(psMap.get((Object)FreeBsdOperatingSystem.PsKeywords.RSS), 0L) * 1024L;
        long elapsedTime = Builder.parseDHMSOrDefault(psMap.get((Object)FreeBsdOperatingSystem.PsKeywords.ETIMES), 0L);
        this.upTime = elapsedTime < 1L ? 1L : elapsedTime;
        this.startTime = now - this.upTime;
        this.kernelTime = Builder.parseDHMSOrDefault(psMap.get((Object)FreeBsdOperatingSystem.PsKeywords.SYSTIME), 0L);
        this.userTime = Builder.parseDHMSOrDefault(psMap.get((Object)FreeBsdOperatingSystem.PsKeywords.TIME), 0L) - this.kernelTime;
        this.path = psMap.get((Object)FreeBsdOperatingSystem.PsKeywords.COMM);
        this.name = this.path.substring(this.path.lastIndexOf(47) + 1);
        this.minorFaults = Builder.parseLongOrDefault(psMap.get((Object)FreeBsdOperatingSystem.PsKeywords.MAJFLT), 0L);
        this.majorFaults = Builder.parseLongOrDefault(psMap.get((Object)FreeBsdOperatingSystem.PsKeywords.MINFLT), 0L);
        long nonVoluntaryContextSwitches = Builder.parseLongOrDefault(psMap.get((Object)FreeBsdOperatingSystem.PsKeywords.NVCSW), 0L);
        long voluntaryContextSwitches = Builder.parseLongOrDefault(psMap.get((Object)FreeBsdOperatingSystem.PsKeywords.NIVCSW), 0L);
        this.contextSwitches = voluntaryContextSwitches + nonVoluntaryContextSwitches;
        this.commandLineBackup = psMap.get((Object)FreeBsdOperatingSystem.PsKeywords.ARGS);
        return true;
    }

    static enum PsThreadColumns {
        TDNAME,
        LWP,
        STATE,
        ETIMES,
        SYSTIME,
        TIME,
        TDADDR,
        NIVCSW,
        NVCSW,
        MAJFLT,
        MINFLT,
        PRI;

    }
}

