/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.http.metric.http;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import org.aoju.bus.core.exception.InstrumentException;
import org.aoju.bus.http.Callback;
import org.aoju.bus.http.GiveCall;
import org.aoju.bus.http.Httpv;
import org.aoju.bus.http.NewCall;
import org.aoju.bus.http.OnBack;
import org.aoju.bus.http.Response;
import org.aoju.bus.http.Results;
import org.aoju.bus.http.magic.RealResult;
import org.aoju.bus.http.metric.TaskExecutor;
import org.aoju.bus.http.metric.http.CoverHttp;

public class AsyncHttp
extends CoverHttp<AsyncHttp> {
    private OnBack<Results> onResponse;
    private OnBack<IOException> onException;
    private OnBack<Results.State> onComplete;
    private boolean rOnIO;
    private boolean eOnIO;
    private boolean cOnIO;

    public AsyncHttp(Httpv htttpv, String url) {
        super(htttpv, url);
    }

    public AsyncHttp setOnException(OnBack<IOException> onException) {
        this.onException = onException;
        this.eOnIO = this.nextOnIO;
        this.nextOnIO = false;
        return this;
    }

    public AsyncHttp setOnComplete(OnBack<Results.State> onComplete) {
        this.onComplete = onComplete;
        this.cOnIO = this.nextOnIO;
        this.nextOnIO = false;
        return this;
    }

    public AsyncHttp setOnResponse(OnBack<Results> onResponse) {
        this.onResponse = onResponse;
        this.rOnIO = this.nextOnIO;
        this.nextOnIO = false;
        return this;
    }

    public GiveCall get() {
        return this.request("GET");
    }

    public GiveCall head() {
        return this.request("HEAD");
    }

    public GiveCall post() {
        return this.request("POST");
    }

    public GiveCall put() {
        return this.request("PUT");
    }

    public GiveCall patch() {
        return this.request("PATCH");
    }

    public GiveCall delete() {
        return this.request("DELETE");
    }

    public GiveCall request(String method) {
        if (null == method || method.isEmpty()) {
            throw new IllegalArgumentException("Request method method cannot be empty!");
        }
        PreGiveCall call = new PreGiveCall();
        this.registeTagTask(call);
        this.httpv.preprocess(this, () -> {
            PreGiveCall preGiveCall = call;
            synchronized (preGiveCall) {
                if (call.canceled) {
                    this.removeTagTask();
                } else {
                    call.setCall(this.executeCall(this.prepareCall(method)));
                }
            }
        }, this.skipPreproc, this.skipSerialPreproc);
        return call;
    }

    private GiveCall executeCall(NewCall call) {
        final OkGiveCall httpCall = new OkGiveCall(call);
        call.enqueue(new Callback(){

            @Override
            public void onFailure(NewCall call, IOException error) {
                Results.State state = AsyncHttp.this.toState(error);
                RealResult result = new RealResult(AsyncHttp.this, state, error);
                AsyncHttp.this.onCallback(httpCall, result, () -> {
                    TaskExecutor executor = AsyncHttp.this.httpv.executor();
                    executor.executeOnComplete(AsyncHttp.this, AsyncHttp.this.onComplete, state, AsyncHttp.this.cOnIO);
                    if (!executor.executeOnException(AsyncHttp.this, AsyncHttp.this.onException, error, AsyncHttp.this.eOnIO) && !AsyncHttp.this.nothrow) {
                        throw new InstrumentException(error.getMessage(), error);
                    }
                });
            }

            @Override
            public void onResponse(NewCall call, Response response) {
                TaskExecutor executor = AsyncHttp.this.httpv.executor();
                RealResult result = new RealResult(AsyncHttp.this, response, executor);
                AsyncHttp.this.onCallback(httpCall, result, () -> {
                    executor.executeOnComplete(AsyncHttp.this, AsyncHttp.this.onComplete, Results.State.RESPONSED, AsyncHttp.this.cOnIO);
                    executor.executeOnResponse(AsyncHttp.this, AsyncHttp.this.onResponse, result, AsyncHttp.this.rOnIO);
                });
            }
        });
        return httpCall;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onCallback(OkGiveCall httpCall, Results result, Runnable runnable) {
        OkGiveCall okGiveCall = httpCall;
        synchronized (okGiveCall) {
            this.removeTagTask();
            if (httpCall.isCanceled() || result.getState() == Results.State.CANCELED) {
                httpCall.setResult(new RealResult(this, Results.State.CANCELED));
                return;
            }
            httpCall.setResult(result);
            runnable.run();
        }
    }

    class PreGiveCall
    implements GiveCall {
        GiveCall call;
        boolean canceled = false;
        CountDownLatch latch = new CountDownLatch(1);

        PreGiveCall() {
        }

        @Override
        public synchronized boolean cancel() {
            this.canceled = null == this.call || this.call.cancel();
            this.latch.countDown();
            return this.canceled;
        }

        @Override
        public boolean isDone() {
            if (null != this.call) {
                return this.call.isDone();
            }
            return this.canceled;
        }

        @Override
        public boolean isCanceled() {
            return this.canceled;
        }

        void setCall(GiveCall call) {
            this.call = call;
            this.latch.countDown();
        }

        @Override
        public Results getResult() {
            if (!AsyncHttp.this.timeoutAwait(this.latch)) {
                this.cancel();
                return AsyncHttp.this.timeoutResult();
            }
            if (this.canceled || null == this.call) {
                return new RealResult(AsyncHttp.this, Results.State.CANCELED);
            }
            return this.call.getResult();
        }
    }

    class OkGiveCall
    implements GiveCall {
        NewCall call;
        Results result;
        CountDownLatch latch = new CountDownLatch(1);

        OkGiveCall(NewCall call) {
            this.call = call;
        }

        @Override
        public synchronized boolean cancel() {
            if (null == this.result) {
                this.call.cancel();
                return true;
            }
            return false;
        }

        @Override
        public boolean isDone() {
            return null != this.result;
        }

        @Override
        public boolean isCanceled() {
            return this.call.isCanceled();
        }

        @Override
        public Results getResult() {
            if (null == this.result && !AsyncHttp.this.timeoutAwait(this.latch)) {
                this.cancel();
                return AsyncHttp.this.timeoutResult();
            }
            return this.result;
        }

        void setResult(Results result) {
            this.result = result;
            this.latch.countDown();
        }
    }
}

