/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.http.metric.suffix;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.IDN;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.aoju.bus.core.io.BufferSource;
import org.aoju.bus.core.io.GzipSource;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.logger.Logger;

public final class SuffixDatabase {
    public static final String PUBLIC_SUFFIX_RESOURCE = "META-INF/suffixes/suffixes.gz";
    private static final byte[] WILDCARD_LABEL = new byte[]{42};
    private static final String[] EMPTY_RULE = Normal.EMPTY_STRING_ARRAY;
    private static final String[] PREVAILING_RULE = new String[]{"*"};
    private static final byte EXCEPTION_MARKER = 33;
    private static final SuffixDatabase instance = new SuffixDatabase();
    private final AtomicBoolean listRead = new AtomicBoolean(false);
    private final CountDownLatch readCompleteLatch = new CountDownLatch(1);
    private byte[] publicSuffixListBytes;
    private byte[] publicSuffixExceptionListBytes;

    public static SuffixDatabase get() {
        return instance;
    }

    private static String binarySearchBytes(byte[] bytesToSearch, byte[][] labels, int labelIndex) {
        int low = 0;
        int high = bytesToSearch.length;
        String match = null;
        while (low < high) {
            int compareResult;
            int mid;
            for (mid = (low + high) / 2; mid > -1 && bytesToSearch[mid] != 10; --mid) {
            }
            ++mid;
            int end = 1;
            while (bytesToSearch[mid + end] != 10) {
                ++end;
            }
            int publicSuffixLength = mid + end - mid;
            int currentLabelIndex = labelIndex;
            int currentLabelByteIndex = 0;
            int publicSuffixByteIndex = 0;
            boolean expectDot = false;
            while (true) {
                int byte0;
                if (expectDot) {
                    byte0 = 46;
                    expectDot = false;
                } else {
                    byte0 = labels[currentLabelIndex][currentLabelByteIndex] & 0xFF;
                }
                int byte1 = bytesToSearch[mid + publicSuffixByteIndex] & 0xFF;
                compareResult = byte0 - byte1;
                if (compareResult != 0) break;
                ++currentLabelByteIndex;
                if (++publicSuffixByteIndex == publicSuffixLength) break;
                if (labels[currentLabelIndex].length != currentLabelByteIndex) continue;
                if (currentLabelIndex == labels.length - 1) break;
                ++currentLabelIndex;
                currentLabelByteIndex = -1;
                expectDot = true;
            }
            if (compareResult < 0) {
                high = mid - 1;
                continue;
            }
            if (compareResult > 0) {
                low = mid + end + 1;
                continue;
            }
            int publicSuffixBytesLeft = publicSuffixLength - publicSuffixByteIndex;
            int labelBytesLeft = labels[currentLabelIndex].length - currentLabelByteIndex;
            for (int i = currentLabelIndex + 1; i < labels.length; ++i) {
                labelBytesLeft += labels[i].length;
            }
            if (labelBytesLeft < publicSuffixBytesLeft) {
                high = mid - 1;
                continue;
            }
            if (labelBytesLeft > publicSuffixBytesLeft) {
                low = mid + end + 1;
                continue;
            }
            match = new String(bytesToSearch, mid, publicSuffixLength, Charset.UTF_8);
            break;
        }
        return match;
    }

    public String getEffectiveTldPlusOne(String domain) {
        String[] rule;
        if (null == domain) {
            throw new NullPointerException("domain == null");
        }
        String unicodeDomain = IDN.toUnicode(domain);
        String[] domainLabels = unicodeDomain.split("\\.");
        if (domainLabels.length == (rule = this.findMatchingRule(domainLabels)).length && rule[0].charAt(0) != '!') {
            return null;
        }
        int firstLabelOffset = rule[0].charAt(0) == '!' ? domainLabels.length - rule.length : domainLabels.length - (rule.length + 1);
        StringBuilder effectiveTldPlusOne = new StringBuilder();
        String[] punycodeLabels = domain.split("\\.");
        for (int i = firstLabelOffset; i < punycodeLabels.length; ++i) {
            effectiveTldPlusOne.append(punycodeLabels[i]).append('.');
        }
        effectiveTldPlusOne.deleteCharAt(effectiveTldPlusOne.length() - 1);
        return effectiveTldPlusOne.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] findMatchingRule(String[] domainLabels) {
        String rule;
        int labelIndex;
        if (!this.listRead.get() && this.listRead.compareAndSet(false, true)) {
            this.readTheListUninterruptibly();
        } else {
            try {
                this.readCompleteLatch.await();
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
            }
        }
        SuffixDatabase ignored = this;
        synchronized (ignored) {
            if (null == this.publicSuffixListBytes) {
                throw new IllegalStateException("Unable to load META-INF/suffixes/suffixes.gz resource from the classpath.");
            }
        }
        byte[][] domainLabelsUtf8Bytes = new byte[domainLabels.length][];
        for (int i = 0; i < domainLabels.length; ++i) {
            domainLabelsUtf8Bytes[i] = domainLabels[i].getBytes(Charset.UTF_8);
        }
        String exactMatch = null;
        for (int i = 0; i < domainLabelsUtf8Bytes.length; ++i) {
            String rule2 = SuffixDatabase.binarySearchBytes(this.publicSuffixListBytes, domainLabelsUtf8Bytes, i);
            if (null == rule2) continue;
            exactMatch = rule2;
            break;
        }
        String wildcardMatch = null;
        if (domainLabelsUtf8Bytes.length > 1) {
            byte[][] labelsWithWildcard = (byte[][])domainLabelsUtf8Bytes.clone();
            for (labelIndex = 0; labelIndex < labelsWithWildcard.length - 1; ++labelIndex) {
                labelsWithWildcard[labelIndex] = WILDCARD_LABEL;
                rule = SuffixDatabase.binarySearchBytes(this.publicSuffixListBytes, labelsWithWildcard, labelIndex);
                if (null == rule) continue;
                wildcardMatch = rule;
                break;
            }
        }
        Object exception = null;
        if (null != wildcardMatch) {
            for (labelIndex = 0; labelIndex < domainLabelsUtf8Bytes.length - 1; ++labelIndex) {
                rule = SuffixDatabase.binarySearchBytes(this.publicSuffixExceptionListBytes, domainLabelsUtf8Bytes, labelIndex);
                if (null == rule) continue;
                exception = rule;
                break;
            }
        }
        if (null != exception) {
            exception = "!" + exception;
            return ((String)exception).split("\\.");
        }
        if (null == exactMatch && null == wildcardMatch) {
            return PREVAILING_RULE;
        }
        String[] exactRuleLabels = null != exactMatch ? exactMatch.split("\\.") : EMPTY_RULE;
        String[] wildcardRuleLabels = null != wildcardMatch ? wildcardMatch.split("\\.") : EMPTY_RULE;
        return exactRuleLabels.length > wildcardRuleLabels.length ? exactRuleLabels : wildcardRuleLabels;
    }

    private void readTheListUninterruptibly() {
        boolean interrupted = false;
        while (true) {
            try {
                this.readTheList();
                return;
            }
            catch (InterruptedIOException e) {
                Thread.interrupted();
                interrupted = true;
                continue;
            }
            catch (IOException e) {
                Logger.warn("Failed to read public suffix list", e);
                return;
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readTheList() throws IOException {
        byte[] publicSuffixExceptionListBytes;
        byte[] publicSuffixListBytes;
        InputStream resource = SuffixDatabase.class.getResourceAsStream(PUBLIC_SUFFIX_RESOURCE);
        if (null == resource) {
            return;
        }
        BufferSource bufferedSource = IoKit.buffer(new GzipSource(IoKit.source(resource)));
        try {
            int totalBytes = bufferedSource.readInt();
            publicSuffixListBytes = new byte[totalBytes];
            bufferedSource.readFully(publicSuffixListBytes);
            int totalExceptionBytes = bufferedSource.readInt();
            publicSuffixExceptionListBytes = new byte[totalExceptionBytes];
            bufferedSource.readFully(publicSuffixExceptionListBytes);
        }
        finally {
            IoKit.close(bufferedSource);
        }
        SuffixDatabase suffixDatabase = this;
        synchronized (suffixDatabase) {
            this.publicSuffixListBytes = publicSuffixListBytes;
            this.publicSuffixExceptionListBytes = publicSuffixExceptionListBytes;
        }
        this.readCompleteLatch.countDown();
    }

    void setListBytes(byte[] publicSuffixListBytes, byte[] publicSuffixExceptionListBytes) {
        this.publicSuffixListBytes = publicSuffixListBytes;
        this.publicSuffixExceptionListBytes = publicSuffixExceptionListBytes;
        this.listRead.set(true);
        this.readCompleteLatch.countDown();
    }
}

