/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.metric.internal.hl7;

import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import org.aoju.bus.image.metric.Connection;
import org.aoju.bus.image.metric.internal.hl7.DefaultHL7Listener;
import org.aoju.bus.image.metric.internal.hl7.HL7Application;
import org.aoju.bus.image.metric.internal.hl7.HL7Exception;
import org.aoju.bus.image.metric.internal.hl7.HL7MessageListener;
import org.aoju.bus.image.metric.internal.hl7.HL7Service;
import org.aoju.bus.image.metric.internal.hl7.UnparsedHL7Message;

public class HL7ServiceRegistry
extends DefaultHL7Listener {
    private final ArrayList<HL7Service> services = new ArrayList();
    private final HashMap<String, HL7MessageListener> listeners = new HashMap();

    public synchronized void addHL7Service(HL7Service service) {
        this.services.add(service);
        for (String messageType : service.getMessageTypes()) {
            this.listeners.put(messageType, service);
        }
    }

    public synchronized boolean removeHL7Service(HL7Service service) {
        if (!this.services.remove(service)) {
            return false;
        }
        for (String messageType : service.getMessageTypes()) {
            this.listeners.remove(messageType);
        }
        return true;
    }

    @Override
    public UnparsedHL7Message onMessage(HL7Application hl7App, Connection conn, Socket s, UnparsedHL7Message msg) throws HL7Exception {
        HL7MessageListener listener = this.listeners.get(msg.msh().getMessageType());
        if (null == listener && null == (listener = this.listeners.get("*"))) {
            return super.onMessage(hl7App, conn, s, msg);
        }
        return listener.onMessage(hl7App, conn, s, msg);
    }
}

