/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.metric.internal.pdu;

import org.aoju.bus.image.UID;
import org.aoju.bus.image.galaxy.Property;

public class RoleSelection {
    private final String cuid;
    private final boolean scu;
    private final boolean scp;

    public RoleSelection(String cuid, boolean scu, boolean scp) {
        if (null == cuid) {
            throw new NullPointerException("cuid cannot be null");
        }
        this.cuid = cuid;
        this.scu = scu;
        this.scp = scp;
    }

    public final String getSOPClassUID() {
        return this.cuid;
    }

    public final boolean isSCU() {
        return this.scu;
    }

    public final boolean isSCP() {
        return this.scp;
    }

    public int length() {
        return this.cuid.length() + 4;
    }

    public String toString() {
        return this.promptTo(new StringBuilder()).toString();
    }

    StringBuilder promptTo(StringBuilder sb) {
        sb.append("  RoleSelection[").append(Property.LINE_SEPARATOR).append("    sopClass: ");
        return UID.promptTo(this.cuid, sb).append(Property.LINE_SEPARATOR).append("    scu: ").append(this.scu).append(Property.LINE_SEPARATOR).append("    scp: ").append(this.scp).append(Property.LINE_SEPARATOR).append("  ]");
    }
}

