/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.plugin;

import java.io.IOException;
import java.util.List;
import org.aoju.bus.core.exception.InstrumentException;
import org.aoju.bus.image.Tag;
import org.aoju.bus.image.galaxy.data.Attributes;
import org.aoju.bus.image.galaxy.data.ElementDictionary;
import org.aoju.bus.image.galaxy.data.Fragments;
import org.aoju.bus.image.galaxy.data.Sequence;
import org.aoju.bus.image.galaxy.data.VR;
import org.aoju.bus.image.galaxy.io.ImageInputHandler;
import org.aoju.bus.image.galaxy.io.ImageInputStream;

public class DcmDump
implements ImageInputHandler {
    private static final int DEFAULT_WIDTH = 78;
    private int width = 78;

    private static String fname(List<String> argList) throws InstrumentException {
        int numArgs = argList.size();
        if (numArgs == 0) {
            throw new InstrumentException("missing");
        }
        if (numArgs > 1) {
            throw new InstrumentException("too-many");
        }
        return argList.get(0);
    }

    public final int getWidth() {
        return this.width;
    }

    public final void setWidth(int width) {
        if (width < 40) {
            throw new IllegalArgumentException();
        }
        this.width = width;
    }

    public void parse(ImageInputStream dis) throws IOException {
        dis.setImageInputHandler(this);
        dis.readDataset(-1, -1);
    }

    @Override
    public void startDataset(ImageInputStream dis) {
        this.promptPreamble(dis.getPreamble());
    }

    @Override
    public void endDataset(ImageInputStream dis) {
    }

    @Override
    public void readValue(ImageInputStream dis, Attributes attrs) throws IOException {
        boolean undeflen;
        StringBuilder line = new StringBuilder(this.width + 30);
        this.appendPrefix(dis, line);
        this.appendHeader(dis, line);
        VR vr = dis.vr();
        int vallen = dis.length();
        boolean bl = undeflen = vallen == -1;
        if (vr == VR.SQ || undeflen) {
            this.appendKeyword(dis, line);
            dis.readValue(dis, attrs);
            if (undeflen) {
                line.setLength(0);
                this.appendPrefix(dis, line);
                this.appendHeader(dis, line);
                this.appendKeyword(dis, line);
            }
            return;
        }
        int tag = dis.tag();
        byte[] b = dis.readValue();
        line.append(" [");
        if (vr.prompt(b, dis.bigEndian(), attrs.getSpecificCharacterSet(), this.width - line.length() - 1, line)) {
            line.append(']');
            this.appendKeyword(dis, line);
        }
        if (tag == 131072) {
            dis.setFileMetaInformationGroupLength(b);
        } else if (tag == 131088 || tag == 524293 || Tag.isPrivateCreator(tag)) {
            attrs.setBytes(tag, vr, b);
        }
    }

    @Override
    public void readValue(ImageInputStream dis, Sequence seq) throws IOException {
        StringBuilder line = new StringBuilder(this.width);
        this.appendPrefix(dis, line);
        this.appendHeader(dis, line);
        this.appendKeyword(dis, line);
        this.appendNumber(seq.size() + 1, line);
        boolean undeflen = dis.length() == -1;
        dis.readValue(dis, seq);
        if (undeflen) {
            line.setLength(0);
            this.appendPrefix(dis, line);
            this.appendHeader(dis, line);
            this.appendKeyword(dis, line);
        }
    }

    @Override
    public void readValue(ImageInputStream dis, Fragments frags) throws IOException {
        StringBuilder line = new StringBuilder(this.width + 20);
        this.appendPrefix(dis, line);
        this.appendHeader(dis, line);
        this.appendFragment(line, dis, frags.vr());
    }

    private void appendPrefix(ImageInputStream dis, StringBuilder line) {
        line.append(dis.getTagPosition()).append(": ");
        int level = dis.level();
        while (level-- > 0) {
            line.append('>');
        }
    }

    private void appendHeader(ImageInputStream dis, StringBuilder line) {
        line.append(Tag.toString(dis.tag())).append(' ');
        VR vr = dis.vr();
        if (null != vr) {
            line.append((Object)vr).append('\t');
        }
        line.append('#').append(dis.length());
    }

    private void appendKeyword(ImageInputStream dis, StringBuilder line) {
        if (line.length() < this.width) {
            line.append(" ");
            line.append(ElementDictionary.keywordOf(dis.tag(), null));
            if (line.length() > this.width) {
                line.setLength(this.width);
            }
        }
    }

    private void appendNumber(int number, StringBuilder line) {
        if (line.length() < this.width) {
            line.append(" #");
            line.append(number);
            if (line.length() > this.width) {
                line.setLength(this.width);
            }
        }
    }

    private void appendFragment(StringBuilder line, ImageInputStream dis, VR vr) throws IOException {
        byte[] b = dis.readValue();
        line.append(" [");
        if (vr.prompt(b, dis.bigEndian(), null, this.width - line.length() - 1, line)) {
            line.append(']');
            this.appendKeyword(dis, line);
        }
    }

    private void promptPreamble(byte[] preamble) {
        if (null == preamble) {
            return;
        }
        StringBuilder line = new StringBuilder(this.width);
        line.append("0: [");
        if (VR.OB.prompt(preamble, false, null, this.width - 5, line)) {
            line.append(']');
        }
    }
}

